<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="js">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta name="author" content="TRS">
    <meta name="description" content="Exercises are structured in adventures with progressive unlocking.">

    <title>@yield('title') | {{ config('app.name') }}</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <link rel="stylesheet" href="{{ asset('assets/css/theme.min.css?ver=3.2.3') }}">

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <script>
        let fallbackThumbnail = "{{ asset('assets/images/placeholder.png') }}";

        // Bind image on error. ie = Image Error
        function _ie(_self) {
            _self.src = fallbackThumbnail;
        }
    </script>

    @stack('styles')
</head>

<body class="nk-body bg-lighter npc-default has-sidebar {{ $isDarkMode ? 'dark-mode' : '' }}">
    <div class="nk-app-root">
        <div class="nk-main ">
            @include('layouts.sidebar')

            <div class="nk-wrap ">
                @include('layouts.header')

                <!-- content @s -->
                <div class="nk-content ">
                    <div class="container-fluid">
                        <div class="nk-content-inner">
                            <div class="nk-content-body">
                                @include('layouts.partials.user-notices')

                                @yield('content')
                            </div>
                        </div>
                    </div>
                </div>
                <!-- content @e -->

                @include('layouts.footer')

            </div>
        </div>
    </div>
    <!-- app-root @e -->

    <!-- Async modal @s -->
    <div class="modal fade zoom" id="async-modal" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <a href="javascript:void(0);" class="close" async-modal-close>
                    <em class="icon ni ni-cross"></em>
                </a>
                <div class="modal-body modal-body-lg">
                    <div id="content"></div>
                    <div id="spinner">
                        <div class="modal-body text-center">
                            <div class="spinner-border text-center" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Async modal @e -->

    <!-- JavaScript -->
    <script>
        let hoursTranslation = "{{ trans('global.time-hours') }}";
        let minutesTranslation = "{{ trans('global.time-minutes') }}";

        let tableBodyNoDataAvailableText = "{{ trans('global.table.body.no_data_available') }}";
        let tableBodyNoMatchingRecordsFoundText = "{{ trans('global.table.body.no_matching_records_found') }}";
        let tableFooterShowingText = "{{ trans('global.table.footer.showing') }}";
        let tableFooterToText = "{{ trans('global.table.footer.to') }}";
        let tableFooterOfText = "{{ trans('global.table.footer.of') }}";
        let tableFooterEntriesText = "{{ trans('global.table.footer.entries') }}";

        let tableFooterPaginationPreviousButtonText = "{{ trans('global.table.footer.pagination.button.previous') }}";
        let tableFooterPaginationNextButtonText = "{{ trans('global.table.footer.pagination.button.next') }}";
    </script>
    <script src="{{ asset('assets/js/bundle.js?ver=3.2.3') }}"></script>
    <script src="{{ asset('assets/js/scripts.js?ver=3.2.3') }}"></script>

    <script>
        $.extend(true, $.fn.dataTable.defaults, {
            oLanguage: {
                sSearch: '',
                sSearchPlaceholder: "{{ __('global.table.search.placeholder') }}",
                sLengthMenu: "{{ __('global.table.search.pagination.menu') }}" + ' _MENU_',
            }
        });

        setTimeout(() => {
            $('.alert-dismisable').slideUp(300);
        }, 3500);
    </script>

    @stack('scripts')
</body>

</html>
