<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="js">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta name="author" content="TRS">
    <meta name="description" content="Exercises are structured in adventures with progressive unlocking.">

    <title>@yield('title') | {{ config('app.name') }}</title>

    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
    <link rel="stylesheet" href="{{ asset('assets/css/theme.min.css?ver=3.2.3') }}">

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    @stack('styles')
</head>

<body class="nk-body ui-rounder npc-default pg-auth">
    <!-- app-root @s -->
    <div class="nk-app-root">
        <div class="nk-main">
            <!-- wrap @s -->
            <div class="nk-wrap nk-wrap-nosidebar">
                <!-- content @s -->
                <div class="nk-content ">
                    <div class="nk-block nk-block-middle nk-auth-body {{ isset($cardWidth) ? $cardWidth : 'wide-xs' }}">
{{--                        @include('layouts.auth.header')--}}

                        @yield('content')
                    </div>

                    @include('layouts.auth.footer')
                </div>
                <!-- content @e -->
            </div>
            <!-- wrap @e -->
        </div>
    </div>
    <!-- app-root @e -->

    <!-- JavaScript -->
    <script>
        let hoursTranslation = "{{ trans('global.time-hours') }}";
        let minutesTranslation = "{{ trans('global.time-minutes') }}";

        let tableBodyNoDataAvailableText = "{{ trans('global.table.body.no_data_available') }}";
        let tableBodyNoMatchingRecordsFoundText = "{{ trans('global.table.body.no_matching_records_found') }}";
        let tableFooterShowingText = "{{ trans('global.table.footer.showing') }}";
        let tableFooterToText = "{{ trans('global.table.footer.to') }}";
        let tableFooterOfText = "{{ trans('global.table.footer.of') }}";
        let tableFooterEntriesText = "{{ trans('global.table.footer.entries') }}";

        let tableFooterPaginationPreviousButtonText = "{{ trans('global.table.footer.pagination.button.previous') }}";
        let tableFooterPaginationNextButtonText = "{{ trans('global.table.footer.pagination.button.next') }}";
    </script>

    <script src="{{ asset('assets/js/bundle.js?ver=3.2.3') }}"></script>
    <script src="{{ asset('assets/js/scripts.js?ver=3.2.3') }}"></script>

    @stack('scripts')
</body>

</html>
