@php $url = isset($notification) ? route('notifications.update', $notification->uuid) : route('notifications.store'); @endphp

<h5 class="title pb-3">{{ isset($notification) ? 'Update' : 'Add New' }} Notification</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#notifications-dt">
    @csrf

    @isset($notification)
        @method('put')
    @endisset

    <div class="row gy-4">
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="title">Title <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="title" name="title" placeholder="Enter title name"
                    value="{{ isset($notification) ? $notification->title : '' }}" required>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="notification">Notification <span class="text-danger">*</span></label>
                <textarea class="form-control" id="notification" name="notification" placeholder="Enter notification name" required>{{ isset($notification) ? $notification->message : '' }}</textarea>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">{{ isset($notification) ? 'Update' : 'Add' }}</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>
