<link rel="stylesheet" href="{{ asset('assets/css/summernote-3.2.3.css') }}">

@php $url = isset($operation) ? route('operations.update', $operation->uuid) : route('operations.store'); @endphp

<h5 class="title pb-3">{{ isset($operation) ? 'Update' : 'Add New' }} Operation</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#operations-dt">
    @csrf

    @isset($operation)
        @method('put')
    @endisset

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="operation">@lang('operation.form.name.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="operation" name="operation" placeholder="@lang('operation.form.name.placeholder')" required value="{{ old('operation', isset($operation) ? $operation->operation : '') }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">{{ isset($operation) ? 'Update' : 'Add' }}</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="{{ asset('assets/js/summernote-3.2.3.js') }}"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
