<link rel="stylesheet" href="{{ asset('assets/css/summernote-3.2.3.css') }}">

@php $url = isset($page) ? route('pages.update', $page->uuid) : route('pages.store'); @endphp

<h5 class="title pb-3">{{ isset($page) ? 'Update' : 'Add New' }} Page</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#pages-dt">
    @csrf

    @isset($page)
        @method('put')
    @endisset

    <div class="row gy-4">
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="name">Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="name" name="name" placeholder="Enter page name" required value="{{ isset($page) ? $page->name : '' }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="description">Description</label>
                <textarea id="summernote" name="description" style="display: none;">{{ isset($page) ? $page?->description : '' }}</textarea>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">{{ isset($page) ? 'Update' : 'Add' }}</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="{{ asset('assets/js/summernote-3.2.3.js') }}"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
