@extends('layouts.auth.app')

@section('title', $page->name)

@push('styles')
    <style>
        .nk-auth-body,
        .nk-auth-footer {
            max-width: none;
        }

        @media (min-width: 567px) {
            .wide-xs {
                max-width: none !important;
            }
        }
    </style>
@endpush

@section('content')
    <div class="container">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="content-page">
                    <div class="nk-block-head nk-block-head-lg pb-3 wide-md">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title fw-normal">{{ $page->name }}</h3>
                        </div>
                    </div><!-- .nk-block-head -->
                    <div class="nk-block">
                        <div class="card card-bordered">
                            <div class="card-inner card-inner-xl p-5">
                                <article class="entry">
                                    <p>{!! $page->description !!}</p>
                                </article>
                            </div>
                        </div>
                    </div><!-- .nk-block -->
                </div><!-- .content-page -->
            </div>
        </div>
    </div>
@endsection
