@extends('layouts.app')

@section('title', trans('profile.page.title'))

@section('content')
    @php
        $primaryAddress = $dealer->addresses->firstWhere('is_primary', true) ?? $dealer->addresses->first();
    @endphp

    <div class="nk-content-inner">
        <div class="nk-content-body">
            <div class="nk-block">
                <div class="card card-bordered">
                    <div class="card-aside-wrap">

                        {{-- Sidebar --}}
                        <div class="card-aside card-aside-left user-aside toggle-slide toggle-slide-left toggle-break-lg toggle-screen-lg" data-content="userAside"
                            data-toggle-screen="lg" data-toggle-overlay="true">
                            <div class="card-inner-group" data-simplebar>
                                <div class="card-inner">
                                    <div class="user-card">
                                        <div class="user-avatar auth-avatar">{!! getAvatarHtml() !!}</div>
                                        <div class="user-info">
                                            <span class="lead-text auth-name">{{ auth()->user()->fullName }}</span>
                                            <span class="sub-text">{{ auth()->user()->email }}</span>
                                        </div>
                                        <div class="user-action">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-trigger mr-n2" data-bs-toggle="dropdown" href="javascript:void(0);">
                                                    <em class="icon ni ni-more-v"></em>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    <ul class="link-list-opt no-bdr">
                                                        <li>
                                                            <a href="{{ route('profile.avatar.edit') }}" async-modal data-method="post">
                                                                <em class="icon ni ni-camera-fill"></em>
                                                                <span>@lang('profile.sidebar.dropdown.change_photo')</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Tabs --}}
                                <div class="card-inner p-0">
                                    <ul class="link-list-menu">
                                        <li><a class="nav-link" data-toggle="tab" href="#account-info"><em
                                                    class="icon ni ni-account-setting"></em><span>@lang('profile.sidebar.tabs.account_information')</span></a></li>
                                        <li>
                                        <li><a class="nav-link active" data-toggle="tab" href="#company-info"><em
                                                    class="icon ni ni-building"></em><span>@lang('profile.sidebar.tabs.company_information')</span></a></li>
                                        <li><a class="nav-link" data-toggle="tab" href="#representative-info"><em
                                                    class="icon ni ni-user-fill"></em><span>@lang('profile.sidebar.tabs.representative_information')</span></a></li>
                                        <li><a class="nav-link" data-toggle="tab" href="#financial-info"><em class="icon ni ni-wallet-fill"></em><span>@lang('profile.sidebar.tabs.financial_information')</span></a>
                                        </li>
                                        <li><a class="nav-link" data-toggle="tab" href="#business-info"><em class="icon ni ni-building"></em><span>@lang('profile.sidebar.tabs.business_information')</span></a>
                                        </li>
                                        <li><a class="nav-link" data-toggle="tab" href="#documents-info"><em
                                                    class="icon ni ni-archive-fill"></em><span>@lang('profile.sidebar.tabs.documents_information')</span></a></li>
                                        <a href="{{ route('profile.password.edit') }}" async-modal data-method="post">
                                            <em class="icon ni ni-lock-alt-fill"></em>
                                            <span>@lang('profile.sidebar.tabs.change_password')</span>
                                        </a>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                        </div>

                        {{-- Main Content --}}
                        <div class="card-inner card-inner-lg">
                            <div class="tab-content">

                                {{-- Account Information --}}
                                <div class="tab-pane" id="account-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <div class="nk-block-between">
                                            <div class="nk-block-head-content">
                                                <h4 class="nk-block-title">@lang('profile.account_information.detail.title')</h4>
                                                <div class="nk-block-des">
                                                    <p>@lang('profile.account_information.detail.heading')</p>
                                                </div>
                                            </div>
                                            <div class="nk-block-head-content align-self-start d-lg-none">
                                                <a href="javascript:void(0);" class="toggle btn btn-icon btn-trigger mt-n1" data-target="userAside">
                                                    <em class="icon ni ni-menu-alt-r"></em>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="{{ route('profile.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.account_information.detail.name')</span>
                                                <span id="account_name" class="data-value">{{ $dealer->user->fullName ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.account_information.detail.email')</span>
                                                <span id="account_email" class="data-value">{{ $dealer->user->email ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.account_information.detail.phone')</span>
                                                <span id="account_phone" class="data-value">{{ $dealer->user->phone ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.account_information.detail.gender')</span>
                                                <span id="account_gender" class="data-value">{{ $dealer->user->gender ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.account_information.detail.date_of_birth')</span>
                                                <span id="account_dob" class="data-value">{{ $dealer->user->date_of_birth ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>
                                    </div>
                                </div>

                                {{-- Company Information --}}
                                <div class="tab-pane active" id="company-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title">@lang('profile.company_information.title')</h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="{{ route('profile.dealers.company.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.company_information.company_name')</span>
                                                <span id="company_name" class="data-value">{{ $dealer->company_name ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.dealers.company.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.company_information.registration_number')</span>
                                                <span id="registration_number"
                                                    class="data-value">{{ $dealer->registration_number ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.dealers.company.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.company_information.tax_number')</span>
                                                <span id="tax_identification_number"
                                                    class="data-value">{{ $dealer->tax_identification_number ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.dealers.company.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.company_information.address')</span>
                                                <span id="company_address" class="data-value">
                                                    @if ($primaryAddress)
                                                        {{ $primaryAddress->street }},
                                                        {{ $primaryAddress->city }},
                                                        {{ $primaryAddress->state }},
                                                        {{ $primaryAddress->country }}
                                                    @else
                                                        {{ trans('global.text.not_available') }}
                                                    @endif
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.dealers.company.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.company_information.contact_phone')</span>
                                                <span id="contact_phone" class="data-value">{{ $dealer->user->phone ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="{{ route('profile.dealers.company.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.company_information.contact_email')</span>
                                                <span id="contact_email" class="data-value">{{ $dealer->user->email ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                {{-- Representative Information --}}
                                <div class="tab-pane" id="representative-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title">@lang('profile.representative_information.title')</h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        @forelse($dealer->representatives as $rep)
                                            <a href="{{ route('profile.dealers.representative.edit', $rep->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.representative_information.full_name')</span>
                                                    <span id="rep_full_name_{{ $rep->id }}" class="data-value">{{ $rep->full_name }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="{{ route('profile.dealers.representative.edit', $rep->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.representative_information.cnic')</span>
                                                    <span id="rep_cnic_{{ $rep->id }}"
                                                        class="data-value">{{ $rep->nic_number ?? trans('global.text.not_available') }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="{{ route('profile.dealers.representative.edit', $rep->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.representative_information.position')</span>
                                                    <span id="rep_position_{{ $rep->id }}"
                                                        class="data-value">{{ $rep->position ?? trans('global.text.not_available') }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="{{ route('profile.dealers.representative.edit', $rep->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.representative_information.contact')</span>
                                                    <span id="rep_contact_{{ $rep->id }}"
                                                        class="data-value">{{ $rep->contact_phone ?? ($rep->contact_email ?? trans('global.text.not_available')) }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>
                                        @empty
                                            <div class="data-item">
                                                <div class="data-col"><span class="data-value">{{ trans('global.text.not_available') }}</span></div>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>

                                {{-- Financial Information --}}
                                <div class="tab-pane" id="financial-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title">@lang('profile.financial_information.title')</h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        @forelse($dealer->finances as $finance)
                                            <a href="{{ route('profile.dealers.financial.edit', $finance->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.financial_information.bank_name')</span>
                                                    <span id="finance_bank_{{ $finance->id }}" class="data-value">{{ $finance->name }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="{{ route('profile.dealers.financial.edit', $finance->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.financial_information.account_holder')</span>
                                                    <span id="finance_holder_{{ $finance->id }}" class="data-value">{{ $finance->account_holder_name }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="{{ route('profile.dealers.financial.edit', $finance->id) }}" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.financial_information.account_number')</span>
                                                    <span id="finance_account_{{ $finance->id }}" class="data-value">{{ $finance->account_number }}</span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>
                                        @empty
                                            <div class="data-item">
                                                <div class="data-col"><span class="data-value">{{ trans('global.text.not_available') }}</span></div>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>

                                {{-- Business Information --}}
                                <div class="tab-pane" id="business-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title">@lang('profile.business_information.title')</h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="{{ route('profile.dealers.business.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.business_information.operations')</span>
                                                <span class="data-value">
                                                    @forelse($dealer->operations as $op)
                                                        <div id="operation_{{ $op->id }}">{{ $op->operation }}</div>
                                                    @empty
                                                        {{ trans('global.text.not_available') }}
                                                    @endforelse
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        @if ($dealer->branches->count())
                                            @foreach ($dealer->branches as $branch)
                                                <a href="{{ route('profile.dealers.business.edit', $branch->id) }}" class="data-item" async-modal data-method="post">
                                                    <div class="data-col">
                                                        <span class="data-label">@lang('profile.business_information.branch_name')</span>
                                                        <span id="branch_name_{{ $branch->id }}"
                                                            class="data-value">{{ $branch->branch_name ?? trans('global.text.not_available') }}</span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </a>
                                            @endforeach
                                        @else
                                            <div class="data-item">
                                                <div class="data-col">
                                                    <span class="data-label">@lang('profile.business_information.branches')</span>
                                                    <span id="branches_count" class="data-value">{{ trans('global.text.not_available') }}</span>
                                                </div>
                                            </div>
                                        @endif

                                        <a href="{{ route('profile.dealers.business.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.business_information.website')</span>
                                                <span id="website_links" class="data-value">{{ $dealer->website ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>
                                    </div>
                                </div>

                                {{-- Documents --}}
                                <div class="tab-pane" id="documents-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title">@lang('profile.documents_information.title')</h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="{{ route('profile.dealers.documents.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.documents_information.business_license')</span>
                                                <span id="doc_business_license" class="data-value">
                                                    {{ $dealer->media->where('type', 'business_license')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available') }}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="{{ route('profile.dealers.documents.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.documents_information.tax_certificate')</span>
                                                <span id="doc_tax_certificate" class="data-value">
                                                    {{ $dealer->media->where('type', 'tax_certificate')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available') }}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="{{ route('profile.dealers.documents.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.documents_information.bank_statement')</span>
                                                <span id="doc_bank_statement" class="data-value">
                                                    {{ $dealer->media->where('type', 'bank_statement')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available') }}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="{{ route('profile.dealers.documents.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.documents_information.constitution')</span>
                                                <span id="doc_constitution" class="data-value">
                                                    {{ $dealer->media->where('type', 'constitution')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available') }}
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="{{ route('profile.dealers.documents.edit') }}" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label">@lang('profile.documents_information.swift')</span>
                                                <span id="doc_swift" class="data-value">{{ $dealer->bank_swift ?? trans('global.text.not_available') }}</span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>
                                    </div>
                                </div>

                            </div> {{-- tab-content --}}
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        const notAvailableText = "{{ trans('global.text.not_available') }}";

        $(document).on('click', '.nav-link', function(e) {
            e.preventDefault();
            const target = $(this).attr('href');
            $('.nav-link').removeClass('active');
            $('.tab-pane').removeClass('active');
            $(this).addClass('active');
            $(target).addClass('active');
        });

        $(document).on('profile.updated', function(e, params) {
            for (const key in params) {
                const value = params[key] ?? notAvailableText;
                const $el = $(`#${key}`);
                if ($el.length) $el.text(value);
                if (key === 'name' || key === 'fullName') {
                    $('.auth-name').text(value);
                }
            }
        });

        $(document).on('avatar.updated', function(e, params) {
            if (params?.url) {
                $('body').find('.auth-avatar').find('img').attr('src', params.url).show().siblings('span').hide();
            }
        });
    </script>
@endpush
