<h5 class="title pb-3">@lang('profile.company_information.edit.title')</h5>

<form action="{{ route('profile.dealers.company.update') }}" method="post" async-form on-async-modal data-event="profile.updated">
    @csrf
    @method('put')

    @php $addr = $dealer->addresses[0] ?? null; @endphp
    <div class="row gy-4">

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Company Name <span class="text-danger">*</span></label>
                <input type="text" name="company_name" class="form-control form-control-lg" value="{{ old('company_name', $dealer->company_name) }}" required>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Registration / License Number <span class="text-danger">*</span></label>
                <input type="text" name="registration_number" class="form-control form-control-lg" value="{{ old('registration_number', $dealer->registration_number) }}"
                    required>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Tax Identification Number (NTN) <span class="text-danger">*</span></label>
                <input type="text" name="tax_identification_number" class="form-control form-control-lg"
                    value="{{ old('tax_identification_number', $dealer->tax_identification_number) }}" required>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">Country</label>
                <input type="text" name="country" class="form-control form-control-lg" value="{{ old('country', optional($addr)->country) }}">
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">State / Province</label>
                <input type="text" name="state" class="form-control form-control-lg" value="{{ old('state', optional($addr)->state) }}">
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">City</label>
                <input type="text" name="city" class="form-control form-control-lg" value="{{ old('city', optional($addr)->city) }}">
            </div>
        </div>

        <div class="col-md-8">
            <div class="form-group">
                <label class="form-label">Street Address</label>
                <input type="text" name="street" class="form-control form-control-lg" value="{{ old('street', optional($addr)->street) }}">
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">Postal Code</label>
                <input type="text" name="postal_code" class="form-control form-control-lg" value="{{ old('postal_code', optional($addr)->postal_code) }}">
            </div>
        </div>

        <div class="col-12">
            <button class="btn btn-primary btn-lg">@lang('global.form.button.save')</button>
        </div>

    </div>
</form>
