<h5 class="title pb-3">@lang('profile.documents_information.edit.title')</h5>

<form action="{{ route('profile.dealers.documents.update') }}" method="post" enctype="multipart/form-data" async-form on-async-modal data-event="profile.updated">
    @csrf
    @method('put')

    @php
        $fileFields = [
            'bank_swift' => 'SWIFT / Branch Code',
            'business_license' => 'Business License',
            'tax_certificate' => 'Tax Certificate',
            'bank_statement' => 'Bank Statement',
            'company_certificate' => 'Company Constitution / Certificate',
        ];
    @endphp

    <div class="row gy-4">
        @foreach ($fileFields as $field => $label)
            @php $doc = $dealer->media->firstWhere('type', $field); @endphp
            <div class="col-md-4">
                <div class="card h-100 shadow-sm rounded-3">
                    <div class="card-body d-flex flex-column justify-content-between">
                        <div>
                            <h6 class="card-title mb-3">{{ $label }}</h6>

                            @if ($doc)
                                <div class="mb-3">
                                    <p class="mb-1">
                                        <strong>File:</strong> {{ $doc->original_name ?? 'Unnamed' }}
                                    </p>
                                    <p class="mb-1">
                                        <strong>Type:</strong> {{ strtoupper(pathinfo($doc->original_name, PATHINFO_EXTENSION)) }}
                                    </p>
                                    <p class="mb-2">
                                        <strong>Size:</strong> {{ number_format($doc->size / 1024, 2) }} KB
                                    </p>
                                    <a href="{{ asset('storage/' . $doc->file_path) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-eye"></i> View Document
                                    </a>
                                </div>
                                <label class="form-label small text-muted">Replace Document:</label>
                                <input type="file" name="{{ $field }}" class="form-control form-control-sm">
                            @else
                                <label class="form-label small text-muted">Upload Document:</label>
                                <input type="file" name="{{ $field }}" class="form-control form-control-sm">
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="mt-4 text-end">
        <button class="btn btn-primary btn-lg">
            <i class="bi bi-save"></i> @lang('global.form.button.save')
        </button>
    </div>
</form>
