<h5 class="title pb-3">@lang('profile.financial_information.edit.title')</h5>

<form action="{{ route('profile.dealers.financial.update') }}" method="post" async-form on-async-modal data-event="profile.updated">
    @csrf
    @method('put')

    @php $finance = $dealer->finances[0] ?? null; @endphp

    <div class="row gy-4">
        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">Bank Name</label>
                <input type="text" name="bank_name" class="form-control form-control-lg" value="{{ old('bank_name', optional($finance)->name) }}">
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">Account Holder</label>
                <input type="text" name="account_holder_name" class="form-control form-control-lg"
                    value="{{ old('account_holder_name', optional($finance)->account_holder_name) }}">
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="form-label">Account Number</label>
                <input type="text" name="account_number" class="form-control form-control-lg" value="{{ old('account_number', optional($finance)->account_number) }}">
            </div>
        </div>

        <div class="col-12">
            <button class="btn btn-primary btn-lg">@lang('global.form.button.save')</button>
        </div>
    </div>
</form>
