<h5 class="title pb-3">@lang('profile.representative_information.edit.title')</h5>

<form action="{{ route('profile.dealers.representative.update') }}" method="post" async-form on-async-modal data-event="profile.updated">
    @csrf
    @method('put')

    @php $rep = $dealer->representatives[0] ?? null; @endphp

    <div class="row gy-4">
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Full Name</label>
                <input type="text" name="rep_name" class="form-control form-control-lg" value="{{ old('rep_name', optional($rep)->full_name) }}">
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">CNIC / Passport</label>
                <input type="text" name="rep_cnic" class="form-control form-control-lg" value="{{ old('rep_cnic', optional($rep)->nic_number) }}">
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Position</label>
                <input type="text" name="rep_position" class="form-control form-control-lg" value="{{ old('rep_position', optional($rep)->position) }}">
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Representative Contact</label>
                <input type="text" name="rep_contact" class="form-control form-control-lg" value="{{ old('rep_contact', optional($rep)->contact_phone) }}">
            </div>
        </div>

        <div class="col-12">
            <button class="btn btn-primary btn-lg">@lang('global.form.button.save')</button>
        </div>
    </div>
</form>
