<h5 class="title pb-3">@lang('profile.modal.header.edit.title')</h5>

<form action="{{ route('profile.update') }}" method="post" async-form on-async-modal data-event="profile.updated">
    @csrf

    @method('put')

    <div class="row gy-4">
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="first_name">@lang('profile.account_information.form.first_name.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control form-control-lg" id="first_name" name="first_name" value="{{ auth()->user()->first_name }}"
                    placeholder="Enter first name" required>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="last_name">@lang('profile.account_information.form.last_name.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control form-control-lg" id="last_name" name="last_name" value="{{ auth()->user()->last_name }}"
                    placeholder="@lang('profile.account_information.form.last_name.placeholder')" required>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="phone">@lang('profile.account_information.form.phone.label')</label>
                <input type="text" class="form-control form-control-lg" id="phone" name="phone" value="{{ auth()->user()->phone }}" placeholder="@lang('profile.account_information.form.phone.placeholder')">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="gender">@lang('profile.account_information.form.gender.label')</label>
                <select name="gender" id="gender" class="form-select form-select-lg">
                    <option>@lang('profile.account_information.form.gender.select_option')</option>
                    <option value="{{ App\Models\User::GENDER_MALE }}" @selected(auth()->user()->gender === App\Models\User::GENDER_MALE)>@lang('global.gender.male')</option>
                    <option value="{{ App\Models\User::GENDER_FEMALE }}" @selected(auth()->user()->gender === App\Models\User::GENDER_FEMALE)>@lang('global.gender.female')</option>
                </select>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="dob">@lang('profile.account_information.form.date_of_birth.label')</label>
                <input type="date" class="form-control form-control-lg" id="dob" name="dob" value="{{ auth()->user()->dob }}" placeholder="@lang('profile.account_information.form.date_of_birth.placeholder')">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.save')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>
    </div>
    </div>
</form>


