<div class="row gy-4">
    <div class="col-md-4">
        <div class="form-group">
            <label class="form-label" for="fv-name">@lang('roles.form.name.label') <span class="text-danger">*</span></label>
            <div class="form-control-wrap">
                <input type="text" class="form-control  @error('name') is-invalid @enderror" id="fv-name" name="name"
                    value="{{ isset($role) && !$errors->has('name') ? $role->name : old('name') }}" placeholder="@lang('roles.form.name.label')" required=""
                    @if (isset($role) && !$role->is_deletable) readonly @endif>
                @if (isset($role) && !$role->is_deletable)
                    <small class="text-danger mt-2">@lang('roles.form.messages.system_roles')</small>
                @endif
                @error('name')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
            </div>
        </div>
    </div>
</div>

<hr class="preview-hr">
<span class="preview-title-lg overline-title">@lang('roles.form.permissions.label')</span>
<div class="row gy-4 pt-2">
    @foreach ($permissionGroups as $group => $permissionGroup)
        <div class="col-lg-4">
            <div class="form-group">
                <label class="form-label">{{ replaceUnderscores($group) }}</label>
                <ul class="custom-control-group g-3 align-center">
                    @foreach ($permissionGroup as $permission)
                        <li>
                            <div class="custom-control custom-switch checked">
                                <input type="checkbox" class="custom-control-input" name="permissions[]" id="{{ $permission->name }}" value="{{ $permission->name }}"
                                    @if (isset($role) && $role->permissions->contains('id', $permission->id)) checked @endif>
                                <label class="custom-control-label"
                                    for="{{ $permission->name }}">{{ replaceUnderscores(trimModuleNameFromPermission($permission->name)) }}</label>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    @endforeach
</div>
<div class="row mt-5">
    <div class="col-md-12">
        <div class="form-group">
            <button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.save')</button>
        </div>
    </div>
</div>
