<link rel="stylesheet" href="{{ asset('assets/css/summernote-3.2.3.css') }}">

@php $url = isset($tax) ? route('taxes.update', $tax->uuid) : route('taxes.store'); @endphp

<h5 class="title pb-3">{{ isset($tax) ? 'Update' : 'Add New' }} Tax</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#taxes-dt">
    @csrf

    @isset($tax)
        @method('put')
    @endisset

    <div class="row gy-4">
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="name">@lang('tax.form.name.label')<span class="text-danger">*</span></label>
                <select class="form-control" id="state_id" name="state_id" required>
                <option value="">Select State</option>
                @foreach($states as $state)
                    <option value="{{ $state->id }}" {{ isset($tax) && $tax->state_id == $state->id ? 'selected' : '' }}>
                        {{ $state->name }}
                    </option>
                @endforeach
            </select>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="tax">@lang('tax.form.tax.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="tax" name="tax" placeholder="@lang('tax.form.tax.placeholder')" required value="{{ isset($tax) ? $tax->tax : '' }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="custom_tax">@lang('tax.form.custom_tax.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="custom_tax" name="custom_tax" placeholder="@lang('tax.form.custom_tax.placeholder')" required value="{{ isset($tax) ? $tax->custom_tax : '' }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="shipping_fee">@lang('tax.form.shipping_fee.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="shipping_fee" name="shipping_fee" placeholder="@lang('tax.form.shipping_fee.placeholder')" required value="{{ isset($tax) ? $tax->shipping_fee : '' }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">{{ isset($tax) ? 'Update' : 'Add' }}</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="{{ asset('assets/js/summernote-3.2.3.js') }}"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
