@extends('layouts.app')

@section('title', trans('terms_conditions.page.title'))

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">@lang('terms_conditions.page.heading')</h3>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="pageMenu">
                        <em class="icon ni ni-more-v"></em>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-inner-group">
                <div class="card-inner position-relative card-tools-toggle table-responsive">
                    <table id="terms-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th><span class="sub-text">#</span></th>
                                <th><span class="sub-text">@lang('terms_conditions.table.header.position')</span></th>
                                <th><span class="sub-text">@lang('terms_conditions.table.header.title')</span></th>
                                <th><span class="sub-text">@lang('terms_conditions.table.header.content')</span></th>
                                <th><span class="sub-text">@lang('terms_conditions.table.header.created')</span></th>
                                <th><span class="sub-text">@lang('terms_conditions.table.header.updated')</span></th>
                                <th class="text-right"><span class="sub-text">@lang('terms_conditions.table.header.actions')</span></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{ asset('assets/libs/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>

    <script>
        var table = $('#terms-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: "{{ route('terms.dataTable') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'uuid',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'position',
                    name: 'position'
                },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'content',
                    name: 'content'
                },
                {
                    data: 'created',
                    name: 'created'
                },
                {
                    data: 'updated',
                    name: 'updated'
                },
                {
                    data: 'action',
                    name: 'action'
                },
            ],
            createdRow: function(row, data, index) {
                $(row).addClass('nk-tb-item');
            }
        });

        $(document).on("asyncmodal.loaded", function() {
            var editor = tinymce.get("editor-container");

            if (editor) editor.destroy();

            richTextEditor("editor-container");
        });
    </script>
@endpush
