@php $url = isset($term) ? route('terms.update', $term->uuid) : route('terms.store'); @endphp

<h5 class="title pb-3">{{ isset($term) ? trans('terms_conditions.modal.header.edit.title') : trans('terms_conditions.modal.header.create.title') }}</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#terms-dt">
    @csrf

    @isset($term)
        @method('put')
    @endisset

    <div class="row gy-4">
        @if (!isset($term) || $term->position == 'footer' || in_array($term->position, ['guest_footer_terms_condition', 'guest_footer_privacy_policy']))
            <div class="col-md-12">
                <div class="form-group">
                    <label class="form-label" for="title">@lang('terms_conditions.form.title.label')</label>
                    <input class="form-control form-control-lg" id="title" name="title" placeholder="@lang('terms_conditions.form.title.placeholder')"
                        value="{{ isset($term) ? $term->title : '' }}"></input>
                    <span class="invalid-feedback pb-3" role="alert"></span>
                </div>
            </div>
        @endif
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="content">@lang('terms_conditions.form.content.placeholder')</label>
                <textarea class="form-control form-control-lg" id="editor-container" name="content" placeholder="@lang('terms_conditions.form.content.placeholder')">{{ isset($term) ? $term->content : '' }}</textarea>
                <span class="invalid-feedback pb-3" role="alert"></span>
            </div>
        </div>
        <div class="col-12">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.save')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>
    </div>
</form>
