<h5 class="title pb-3">@lang('users.modal.header.invite.title')</h5>

<form action="{{ route('users.store') }}" method="post" async-form on-async-modal data-datatable="#users-dt">
    @csrf

    <div class="row gy-4">
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="first_name">@lang('users.form.first_name.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control form-control-lg" id="first_name" name="first_name" placeholder="@lang('users.form.first_name.placeholder')" required>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="last_name">@lang('users.form.last_name.label')</label>
                <input type="text" class="form-control form-control-lg" id="last_name" name="last_name" placeholder="@lang('users.form.last_name.placeholder')">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="email">@lang('users.form.email.label') <span class="text-danger">*</span></label>
                <input type="email" class="form-control form-control-lg" id="email" name="email" placeholder="@lang('users.form.email.placeholder')" required>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('users.modal.button.invite')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>
    </div>
</form>
