<h5 class="title pb-3">@lang('users.modal.header.edit.title')</h5>

<form action="{{ route('users.update', $user->uuid) }}" method="post" async-form on-async-modal data-datatable="#users-dt">
    @csrf
    @method('put')

    <div class="col-md-12 mb-3">
        <div class="form-group">
            <label class="form-label" for="first_name">@lang('users.form.first_name.label')</label>
            <input class="form-control form-control-lg" id="first_name" name="first_name" placeholder="@lang('users.form.first_name.placeholder')" value="{{ $user->first_name }}">
            <span class="invalid-feedback" role="alert"></span>
        </div>
    </div>

    <div class="col-md-12 mb-3">
        <div class="form-group">
            <label class="form-label" for="last_name">@lang('users.form.last_name.label')</label>
            <input class="form-control form-control-lg" id="last_name" name="last_name" placeholder="@lang('users.form.last_name.placeholder')" value="{{ $user->last_name }}">
            <span class="invalid-feedback" role="alert"></span>
        </div>
    </div>

    <div class="col-md-12 mb-3">
        <div class="form-group">
            <label class="form-label" for="phone">@lang('users.form.phone.label')</label>
            <input class="form-control form-control-lg" id="phone" name="phone" placeholder="@lang('users.form.phone.placeholder')" value="{{ $user->phone }}">
            <span class="invalid-feedback" role="alert"></span>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-6">
            <div class="custom-control custom-switch checked mb-3">
                <input type="checkbox" class="custom-control-input" name="status" id="status" value="true" @checked($user->status === \App\Enum\Status::ACTIVE)>
                <label class="custom-control-label" for="status">@lang('users.form.active.label')</label>
            </div>
            <span class="invalid-feedback" role="alert"></span>
        </div>

        <div class="col-md-12 mb-3">
            <div class="form-group">
                <label class="form-label" for="comments">@lang('users.form.comments.label')</label>
                <textarea class="form-control form-control-lg" id="comments" name="comments" placeholder="@lang('users.form.comments.placeholder')">{{ $user->admin_comments }}</textarea>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.update')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>
    </div>
</form>
