<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ListingController;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\Auth\RegisterController;
use App\Http\Controllers\Api\Auth\ResendOtpController;
use App\Http\Controllers\Api\Auth\VerifyOtpController;
use App\Http\Controllers\Api\Auth\ResetPasswordController;
use App\Http\Controllers\Api\Auth\ForgotPasswordController;
use App\Http\Controllers\Api\Auth\ConfirmablePasswordController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| These routes are used by both the web frontend (Vue.js) and mobile apps.
| All routes return JSON responses.
|
*/

Route::prefix('listings')->group(function () {
    Route::get('/featured', [ListingController::class, 'featured'])->name('api.listings.featured');
    Route::get('/', [ListingController::class, 'index'])->name('api.listings.index');
    Route::get('/{uuid}', [ListingController::class, 'show'])->name('api.listings.show');
    Route::get('/{uuid}/related', [ListingController::class, 'related'])->name('api.listings.related');
});

// Authentication routes (no CSRF protection needed)
Route::prefix('auth')->group(function () {
    Route::post('/register', [\App\Http\Controllers\Api\AuthController::class, 'register'])->name('api.auth.register');
    Route::post('/login', [\App\Http\Controllers\Api\AuthController::class, 'login'])->name('api.auth.login');
    Route::post('/logout', [\App\Http\Controllers\Api\AuthController::class, 'logout'])->middleware('auth:sanctum')->name('api.auth.logout');
    Route::get('/me', [\App\Http\Controllers\Api\AuthController::class, 'me'])->middleware('auth:sanctum')->name('api.auth.me');
    Route::post('/forgot-password', [\App\Http\Controllers\Api\AuthController::class, 'forgotPassword'])->name('api.auth.forgot-password');
    Route::post('/reset-password', [\App\Http\Controllers\Api\AuthController::class, 'resetPassword'])->name('api.auth.reset-password');
});

// Add more API routes here as needed
// Route::prefix('dealers')->group(function () {
//     Route::get('/', [DealerController::class, 'index']);
// });
