<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Buyer\ShopController;
use App\Http\Controllers\Buyer\FrontendController;
use App\Http\Controllers\Buyer\DashboardController as BuyerDashboardController;

/*
|--------------------------------------------------------------------------
| Buyer Routes
|--------------------------------------------------------------------------
|
| These routes handle both the public buyer frontend (Vue.js SPA) and
| authenticated buyer dashboard routes.
|
*/

// Public Buyer Frontend Routes (Vue.js SPA)
// Root route - serve buyer frontend Vue.js application
Route::get('/', [FrontendController::class, 'index'])->name('buyer.index');

// Shop Route
Route::get('/shop', [ShopController::class, 'index'])->name('shop.index');

// Authenticated Buyer Routes
Route::group(['middleware' => ['auth', 'verified']], function () {
    Route::name('buyers.')->prefix('buyers')->group(function () {
        Route::get('dashboard', [BuyerDashboardController::class, 'index'])->name('dashboard');
    });
});
