<?php

use App\Http\Controllers\Dealer\DashboardController as DealerDashboardController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'verified', 'verified_dealer']], function () {
    // Dealers routes (mirror Users, but scoped to role dealer)
    Route::name('dealers.')->prefix('dealers')->group(function () {
        Route::get('dashboard', [DealerDashboardController::class, 'index'])->name('dashboard');
        
        // Profile routes
        Route::group(['prefix' => 'profile', 'as' => 'profile.'], function () {
            Route::get('/', [\App\Http\Controllers\Dealer\ProfileController::class, 'index'])->name('index');
            Route::post('/', [\App\Http\Controllers\Dealer\ProfileController::class, 'edit'])->name('edit');
            Route::put('/', [\App\Http\Controllers\Dealer\ProfileController::class, 'update'])->name('update');

            // Dealer company info
            Route::post('/company', [\App\Http\Controllers\Dealer\ProfileController::class, 'editCompany'])->name('company.edit');
            Route::put('/company', [\App\Http\Controllers\Dealer\ProfileController::class, 'updateCompany'])->name('company.update');

            // Dealer representative info
            Route::post('/representative/create', [\App\Http\Controllers\Dealer\ProfileController::class, 'createRepresentative'])->name('representative.create');
            Route::post('/representative', [\App\Http\Controllers\Dealer\ProfileController::class, 'storeRepresentative'])->name('representative.store');
            Route::post('/representative/{id}', [\App\Http\Controllers\Dealer\ProfileController::class, 'editRepresentative'])->name('representative.edit');
            Route::put('/representative/{id}', [\App\Http\Controllers\Dealer\ProfileController::class, 'updateRepresentative'])->name('representative.update');

            // Dealer financial info
            Route::post('/financial/create', [\App\Http\Controllers\Dealer\ProfileController::class, 'createFinancial'])->name('financial.create');
            Route::post('/financial', [\App\Http\Controllers\Dealer\ProfileController::class, 'storeFinancial'])->name('financial.store');
            Route::post('/financial/{id}', [\App\Http\Controllers\Dealer\ProfileController::class, 'editFinancial'])->name('financial.edit');
            Route::put('/financial/{id}', [\App\Http\Controllers\Dealer\ProfileController::class, 'updateFinancial'])->name('financial.update');

            // Dealer business info
            Route::post('/business', [\App\Http\Controllers\Dealer\ProfileController::class, 'editBusiness'])->name('business.edit');
            Route::put('/business', [\App\Http\Controllers\Dealer\ProfileController::class, 'updateBusiness'])->name('business.update');

            // Dealer documents
            Route::post('/documents', [\App\Http\Controllers\Dealer\ProfileController::class, 'editDocuments'])->name('documents.edit');
            Route::put('/documents', [\App\Http\Controllers\Dealer\ProfileController::class, 'updateDocuments'])->name('documents.update');

            // Profile terms route
            Route::get('terms', [\App\Http\Controllers\Dealer\ProfileController::class, 'terms'])->name('terms');

            // Avatar routes
            Route::post('/avatar', [\App\Http\Controllers\Dealer\ProfileController::class, 'editAvatar'])->name('avatar.edit');
            Route::put('/avatar', [\App\Http\Controllers\Dealer\ProfileController::class, 'updateAvatar'])->name('avatar.update');

            // Update password routes
            Route::post('/password', [\App\Http\Controllers\Dealer\ProfileController::class, 'editPassword'])->name('password.edit');
            Route::put('/password', [\App\Http\Controllers\Dealer\ProfileController::class, 'updatePassword'])->name('password.update');
        });

        // Settings route
        Route::post('settings', [\App\Http\Controllers\Dealer\SettingsController::class, 'store'])->name('settings.store');
        
        // Listings routes
        Route::post('listings/upload-image', [\App\Http\Controllers\Dealer\ListingController::class, 'uploadImage'])->name('listings.upload-image');
        Route::resource('listings', \App\Http\Controllers\Dealer\ListingController::class);
    });
});
