<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers as Controllers;
use Controllers\DexUsers\DexUserController;
use App\Http\Controllers\Dealer\ListingController;
use App\Http\Controllers\Dealer\DashboardController as DealerDashboardController;

if (!defined('DATA_TABLE_ROUTE')) {
    define('DATA_TABLE_ROUTE', 'data-table');
}

if (!defined('ARCHIVED_DATA_TABLE_ROUTE')) {
    define('ARCHIVED_DATA_TABLE_ROUTE', 'data-table/archived');
}

Route::get('pages/{slug}', [App\Http\Controllers\PageController::class, 'index'])->name('frontend.pages.index');

Route::middleware('auth', 'block_suspended')->prefix('admin')->group(function () {
    // Profile routes
    Route::group(['prefix' => 'profile', 'as' => 'profile.'], function () {
        Route::get('/', [Controllers\Profile\ProfileController::class, 'index'])->name('index');
        Route::post('/', [Controllers\Profile\ProfileController::class, 'edit'])->name('edit');
        Route::put('/', [Controllers\Profile\ProfileController::class, 'update'])->name('update');

        // Avatar routes
        Route::post('/avatar', [Controllers\Profile\AvatarController::class, 'edit'])->name('avatar.edit');
        Route::put('/avatar', [Controllers\Profile\AvatarController::class, 'update'])->name('avatar.update');

        // Update password routes
        Route::post('/password', [Controllers\Profile\UpdatePasswordController::class, 'edit'])->name('password.edit');
        Route::put('/password', [Controllers\Profile\UpdatePasswordController::class, 'update'])->name('password.update');


        // Dealer company info
        Route::post('/dealer/company', [Controllers\Profile\ProfileController::class, 'editCompany'])->name('dealers.company.edit');
        Route::put('/dealer/company', [Controllers\Profile\ProfileController::class, 'updateCompany'])->name('dealers.company.update');

        // Dealer representative info
        Route::post('/dealer/representative', [Controllers\Profile\ProfileController::class, 'editRepresentative'])->name('dealers.representative.edit');
        Route::put('/dealer/representative', [Controllers\Profile\ProfileController::class, 'updateRepresentative'])->name('dealers.representative.update');

        // Dealer financial info
        Route::post('/dealer/financial', [Controllers\Profile\ProfileController::class, 'editFinancial'])->name('dealers.financial.edit');
        Route::put('/dealer/financial', [Controllers\Profile\ProfileController::class, 'updateFinancial'])->name('dealers.financial.update');

        // Dealer business info
        Route::post('/dealer/business', [Controllers\Profile\ProfileController::class, 'editBusiness'])->name('dealers.business.edit');
        Route::put('/dealer/business', [Controllers\Profile\ProfileController::class, 'updateBusiness'])->name('dealers.business.update');

        // Dealer documents
        Route::post('/dealer/documents', [Controllers\Profile\ProfileController::class, 'editDocuments'])->name('dealers.documents.edit');
        Route::put('/dealer/documents', [Controllers\Profile\ProfileController::class, 'updateDocuments'])->name('dealers.documents.update');

        // Profile terms route
        Route::get('terms', [Controllers\Profile\ProfileController::class, 'terms'])->name('terms');
    });

    Route::middleware(['active'])->group(function () {
        // Admin dashboard (original backend)
        Route::get('dashboard', [Controllers\DashboardController::class, 'index'])->name('dashboard');

        // Settings routes
        Route::name('settings.')->prefix('settings')->group(function () {
            Route::get('/', [Controllers\Settings\SettingController::class, 'index'])->name('index');
            Route::post('/', [Controllers\Settings\SettingController::class, 'store'])->name('store');

            Route::name('mail.')->prefix('mail')->group(function () {
                Route::get('/', [Controllers\Settings\MailController::class, 'index'])->name('index');
                Route::get('edit', [Controllers\Settings\MailController::class, 'edit'])->name('edit');
                Route::put('update', [Controllers\Settings\MailController::class, 'update'])->name('update');
            });
        });

        // Customers routes0
        Route::name('users.')->prefix('users')->group(function () {
            Route::post('resend-invitation/{user}', [Controllers\Users\UserController::class, 'resendInvitation'])->name('resend-invitation');
            Route::post('approve/{user}', [Controllers\Users\UserController::class, 'approve'])->name('approve');
            Route::post('verify-email/{user}', [Controllers\Users\UserController::class, 'verifyEmail'])->name('verify-email');
            Route::post('comments/{uuid}', [Controllers\Users\UserController::class, 'comments'])->name('comments');
            Route::post('restore/{user_uuid}', [Controllers\Users\UserController::class, 'restore'])->name('restore');
            Route::get(DATA_TABLE_ROUTE, [Controllers\Users\UserController::class, 'dataTable'])->name('dataTable');
            Route::get(ARCHIVED_DATA_TABLE_ROUTE, [Controllers\Users\UserController::class, 'archivedDataTable'])->name('dataTable.archived');
            Route::resource('/', Controllers\Users\UserController::class)->parameters(['' => 'dealers']);
        });

        // Dealers routes (mirror Users, but scoped to role dealer)
        Route::name('dealers.')->prefix('admin/dealers')->group(function () {
            Route::post('approve/{users}', [Controllers\Admin\Dealers\DealerController::class, 'approve'])->name('approve');
            Route::post('reject/{users}', [Controllers\Admin\Dealers\DealerController::class, 'reject'])->name('reject');
            Route::post('verify-email/{users}', [Controllers\Admin\Dealers\DealerController::class, 'verifyEmail'])->name('verify-email');
            Route::post('restore/{users}', [Controllers\Admin\Dealers\DealerController::class, 'restore'])->name('restore');
            Route::get(DATA_TABLE_ROUTE, [Controllers\Admin\Dealers\DealerController::class, 'dataTable'])->name('dataTable');
            Route::get(ARCHIVED_DATA_TABLE_ROUTE, [Controllers\Admin\Dealers\DealerController::class, 'archivedDataTable'])->name('dataTable.archived');
            Route::resource('/', Controllers\Admin\Dealers\DealerController::class)->parameters(['' => 'users']);
        });

        //Listing Routes For Dealers
        Route::get('listings' . DATA_TABLE_ROUTE, [Controllers\Dealer\ListingController::class, 'dataTable'])->name('dealers.listings.datatable');
        Route::resource('listings', Controllers\Dealer\ListingController::class)->names('dealers.listings');
        // Route::get(ARCHIVED_DATA_TABLE_ROUTE, [Controllers\Admin\Dealers\DealerController::class, 'archivedDataTable'])->name('dealers.listings');

        // Roles routes
        Route::name('roles.')->prefix('roles')->group(function () {
            Route::post('restore/{role}', [Controllers\Roles\RoleController::class, 'restore'])->name('restore');
            Route::get(DATA_TABLE_ROUTE, [Controllers\Roles\RoleController::class, 'dataTable'])->name('dataTable');
            Route::get(ARCHIVED_DATA_TABLE_ROUTE, [Controllers\Roles\RoleController::class, 'archivedDataTable'])->name('dataTable.archived');
            Route::resource('/', Controllers\Roles\RoleController::class)->parameters(['' => 'roles']);
        });

        // Documentations routes
        Route::name('documentations.')->prefix('documentations')->group(function () {
            Route::post('restore/{document}', [Controllers\Documentations\DocumentationController::class, 'restore'])->name('restore');
            Route::get(ARCHIVED_DATA_TABLE_ROUTE, [Controllers\Documentations\DocumentationController::class, 'archivedDataTable'])->name('dataTable.archived');
            Route::get(DATA_TABLE_ROUTE, [Controllers\Documentations\DocumentationController::class, 'dataTable'])->name('dataTable');
            Route::resource('/', Controllers\Documentations\DocumentationController::class)->parameters(['' => 'documentations']);
        });

        //Taxes Route
        Route::get('taxes/' . DATA_TABLE_ROUTE, [Controllers\Taxes\TaxController::class, 'dataTable'])->name('taxes.datatable');
        Route::resource('taxes', Controllers\Taxes\TaxController::class);

        //DexUsers Route
        Route::get('dex-users/' . DATA_TABLE_ROUTE, [Controllers\DexUsers\DexUserController::class, 'dataTable'])->name('dex-users.datatable');
        Route::resource('dex-users', Controllers\DexUsers\DexUserController::class);

        //AdminBuyer Route
        Route::get('admin/buyers/' . DATA_TABLE_ROUTE, [Controllers\Admin\Buyers\AdminBuyerController::class, 'dataTable'])->name('buyers.datatable');
        Route::get('admin/buyers/' . ARCHIVED_DATA_TABLE_ROUTE, [Controllers\Admin\Buyers\AdminBuyerController::class, 'archivedDataTable'])->name('buyers.datatable.archived');
        Route::resource('admin/buyers', Controllers\Admin\Buyers\AdminBuyerController::class);


        //Dx Customer Route
        Route::get('dx-customers/' . DATA_TABLE_ROUTE, [Controllers\DxCustomer\DxCustomerController::class, 'dataTable'])->name('dx-customers.datatable');
        Route::resource('dx-customers', Controllers\DxCustomer\DxCustomerController::class);
        Route::post('dx-customers/activate/{customer}', [Controllers\DxCustomer\DxCustomerController::class, 'activate'])->name('dx-customers.activate');
        Route::post('dx-customers/deactivate/{customer}', [Controllers\DxCustomer\DxCustomerController::class, 'deactivate'])->name('dx-customers.deactivate');

        //Branches Route
        Route::get('branches/' . DATA_TABLE_ROUTE, [Controllers\Dealers\BranchController::class, 'dataTable'])->name('branches.datatable');
        Route::resource('branches', Controllers\Dealers\BranchController::class);

        //OperationApp\Enum\Status Route
        Route::get('operations/' . DATA_TABLE_ROUTE, [Controllers\Dealers\OperationController::class, 'dataTable'])->name('operations.datatable');
        Route::resource('operations', Controllers\Dealers\OperationController::class);

        //Listings Route
        Route::get('listings/data/' . DATA_TABLE_ROUTE, [Controllers\Admin\ListingController::class, 'dataTable'])->name('admin.listings.datatable');
        Route::post('listings/upload-image', [Controllers\Admin\ListingController::class, 'uploadImage'])->name('admin.listings.upload-image');
        Route::post('listings/{listing}/approve', [Controllers\Admin\ListingController::class, 'approve'])->name('admin.listings.approve');
        Route::post('listings/{listing}/reject', [Controllers\Admin\ListingController::class, 'reject'])->name('admin.listings.reject');
        Route::resource('listings', Controllers\Admin\ListingController::class)->names('admin.listings');

        // Pages routes
        Route::get('pages/' . DATA_TABLE_ROUTE, [Controllers\Pages\PageController::class, 'dataTable'])->name('pages.datatable');
        Route::resource('pages', Controllers\Pages\PageController::class);

        // Terms & Condition routes
        Route::name('terms.')->prefix('terms')->group(function () {
            Route::get('data-table', [Controllers\Terms\TermController::class, 'dataTable'])->name('dataTable');
            Route::resource('/', Controllers\Terms\TermController::class)->parameters(['' => 'terms'])->except(['create', 'store']);
        });

        // Activity logs routes
        Route::name('activity-logs.')->prefix('activity-logs')->group(function () {
            Route::get('/', [Controllers\ActivityLogs\ActivityLogController::class, 'index'])->name('index');
            Route::get(DATA_TABLE_ROUTE, [Controllers\ActivityLogs\ActivityLogController::class, 'dataTable'])->name('dataTable');
            Route::get('users', [Controllers\ActivityLogs\ActivityLogController::class, 'getUsers'])->name('users');
            Route::get('modules', [Controllers\ActivityLogs\ActivityLogController::class, 'getModules'])->name('modules');
            Route::get('keys', [Controllers\ActivityLogs\ActivityLogController::class, 'getActivityLogKey'])->name('keys');
        });

        // Notifications routes
        Route::name('notifications.')->prefix('notifications')->group(function () {
            Route::get(DATA_TABLE_ROUTE, [Controllers\GeneralNotifications\NotificationController::class, 'dataTable'])->name('datatable');
            Route::post('send/{notification}', [Controllers\GeneralNotifications\NotificationController::class, 'send'])->name('send');
            Route::resource('/', Controllers\GeneralNotifications\NotificationController::class)->parameters(['' => 'notifications']);
        });
    });
});

require __DIR__ . '/buyer.php';
require __DIR__ . '/auth.php';
require __DIR__ . '/dealer.php';
