<?php $__env->startSection('title', trans('profile.page.title')); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $primaryAddress = $dealer->addresses->firstWhere('is_primary', true) ?? $dealer->addresses->first();
    ?>

    <div class="nk-content-inner">
        <div class="nk-content-body">
            <div class="nk-block">
                <div class="card card-bordered">
                    <div class="card-aside-wrap">

                        
                        <div class="card-aside card-aside-left user-aside toggle-slide toggle-slide-left toggle-break-lg toggle-screen-lg" data-content="userAside"
                            data-toggle-screen="lg" data-toggle-overlay="true">
                            <div class="card-inner-group" data-simplebar>
                                <div class="card-inner">
                                    <div class="user-card">
                                        <div class="user-avatar auth-avatar"><?php echo getAvatarHtml(); ?></div>
                                        <div class="user-info">
                                            <span class="lead-text auth-name"><?php echo e(auth()->user()->fullName); ?></span>
                                            <span class="sub-text"><?php echo e(auth()->user()->email); ?></span>
                                        </div>
                                        <div class="user-action">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-trigger mr-n2" data-bs-toggle="dropdown" href="javascript:void(0);">
                                                    <em class="icon ni ni-more-v"></em>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    <ul class="link-list-opt no-bdr">
                                                        <li>
                                                            <a href="<?php echo e(route('profile.avatar.edit')); ?>" async-modal data-method="post">
                                                                <em class="icon ni ni-camera-fill"></em>
                                                                <span><?php echo app('translator')->get('profile.sidebar.dropdown.change_photo'); ?></span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="card-inner p-0">
                                    <ul class="link-list-menu">
                                        <li><a class="nav-link" data-toggle="tab" href="#account-info"><em
                                                    class="icon ni ni-account-setting"></em><span><?php echo app('translator')->get('profile.sidebar.tabs.account_information'); ?></span></a></li>
                                        <li>
                                        <li><a class="nav-link active" data-toggle="tab" href="#company-info"><em
                                                    class="icon ni ni-building"></em><span><?php echo app('translator')->get('profile.sidebar.tabs.company_information'); ?></span></a></li>
                                        <li><a class="nav-link" data-toggle="tab" href="#representative-info"><em
                                                    class="icon ni ni-user-fill"></em><span><?php echo app('translator')->get('profile.sidebar.tabs.representative_information'); ?></span></a></li>
                                        <li><a class="nav-link" data-toggle="tab" href="#financial-info"><em class="icon ni ni-wallet-fill"></em><span><?php echo app('translator')->get('profile.sidebar.tabs.financial_information'); ?></span></a>
                                        </li>
                                        <li><a class="nav-link" data-toggle="tab" href="#business-info"><em class="icon ni ni-building"></em><span><?php echo app('translator')->get('profile.sidebar.tabs.business_information'); ?></span></a>
                                        </li>
                                        <li><a class="nav-link" data-toggle="tab" href="#documents-info"><em
                                                    class="icon ni ni-archive-fill"></em><span><?php echo app('translator')->get('profile.sidebar.tabs.documents_information'); ?></span></a></li>
                                        <a href="<?php echo e(route('profile.password.edit')); ?>" async-modal data-method="post">
                                            <em class="icon ni ni-lock-alt-fill"></em>
                                            <span><?php echo app('translator')->get('profile.sidebar.tabs.change_password'); ?></span>
                                        </a>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                        </div>

                        
                        <div class="card-inner card-inner-lg">
                            <div class="tab-content">

                                
                                <div class="tab-pane" id="account-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <div class="nk-block-between">
                                            <div class="nk-block-head-content">
                                                <h4 class="nk-block-title"><?php echo app('translator')->get('profile.account_information.detail.title'); ?></h4>
                                                <div class="nk-block-des">
                                                    <p><?php echo app('translator')->get('profile.account_information.detail.heading'); ?></p>
                                                </div>
                                            </div>
                                            <div class="nk-block-head-content align-self-start d-lg-none">
                                                <a href="javascript:void(0);" class="toggle btn btn-icon btn-trigger mt-n1" data-target="userAside">
                                                    <em class="icon ni ni-menu-alt-r"></em>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="<?php echo e(route('profile.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.account_information.detail.name'); ?></span>
                                                <span id="account_name" class="data-value"><?php echo e($dealer->user->fullName ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.account_information.detail.email'); ?></span>
                                                <span id="account_email" class="data-value"><?php echo e($dealer->user->email ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.account_information.detail.phone'); ?></span>
                                                <span id="account_phone" class="data-value"><?php echo e($dealer->user->phone ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.account_information.detail.gender'); ?></span>
                                                <span id="account_gender" class="data-value"><?php echo e($dealer->user->gender ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.account_information.detail.date_of_birth'); ?></span>
                                                <span id="account_dob" class="data-value"><?php echo e($dealer->user->date_of_birth ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>
                                    </div>
                                </div>

                                
                                <div class="tab-pane active" id="company-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title"><?php echo app('translator')->get('profile.company_information.title'); ?></h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="<?php echo e(route('profile.dealers.company.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.company_information.company_name'); ?></span>
                                                <span id="company_name" class="data-value"><?php echo e($dealer->company_name ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.company.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.company_information.registration_number'); ?></span>
                                                <span id="registration_number"
                                                    class="data-value"><?php echo e($dealer->registration_number ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.company.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.company_information.tax_number'); ?></span>
                                                <span id="tax_identification_number"
                                                    class="data-value"><?php echo e($dealer->tax_identification_number ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.company.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.company_information.address'); ?></span>
                                                <span id="company_address" class="data-value">
                                                    <?php if($primaryAddress): ?>
                                                        <?php echo e($primaryAddress->street); ?>,
                                                        <?php echo e($primaryAddress->city); ?>,
                                                        <?php echo e($primaryAddress->state); ?>,
                                                        <?php echo e($primaryAddress->country); ?>

                                                    <?php else: ?>
                                                        <?php echo e(trans('global.text.not_available')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.company.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.company_information.contact_phone'); ?></span>
                                                <span id="contact_phone" class="data-value"><?php echo e($dealer->user->phone ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.company.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.company_information.contact_email'); ?></span>
                                                <span id="contact_email" class="data-value"><?php echo e($dealer->user->email ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                
                                <div class="tab-pane" id="representative-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title"><?php echo app('translator')->get('profile.representative_information.title'); ?></h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <?php $__empty_1 = true; $__currentLoopData = $dealer->representatives; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <a href="<?php echo e(route('profile.dealers.representative.edit', $rep->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.representative_information.full_name'); ?></span>
                                                    <span id="rep_full_name_<?php echo e($rep->id); ?>" class="data-value"><?php echo e($rep->full_name); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="<?php echo e(route('profile.dealers.representative.edit', $rep->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.representative_information.cnic'); ?></span>
                                                    <span id="rep_cnic_<?php echo e($rep->id); ?>"
                                                        class="data-value"><?php echo e($rep->nic_number ?? trans('global.text.not_available')); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="<?php echo e(route('profile.dealers.representative.edit', $rep->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.representative_information.position'); ?></span>
                                                    <span id="rep_position_<?php echo e($rep->id); ?>"
                                                        class="data-value"><?php echo e($rep->position ?? trans('global.text.not_available')); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="<?php echo e(route('profile.dealers.representative.edit', $rep->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.representative_information.contact'); ?></span>
                                                    <span id="rep_contact_<?php echo e($rep->id); ?>"
                                                        class="data-value"><?php echo e($rep->contact_phone ?? ($rep->contact_email ?? trans('global.text.not_available'))); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="data-item">
                                                <div class="data-col"><span class="data-value"><?php echo e(trans('global.text.not_available')); ?></span></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <div class="tab-pane" id="financial-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title"><?php echo app('translator')->get('profile.financial_information.title'); ?></h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <?php $__empty_1 = true; $__currentLoopData = $dealer->finances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <a href="<?php echo e(route('profile.dealers.financial.edit', $finance->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.financial_information.bank_name'); ?></span>
                                                    <span id="finance_bank_<?php echo e($finance->id); ?>" class="data-value"><?php echo e($finance->name); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="<?php echo e(route('profile.dealers.financial.edit', $finance->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.financial_information.account_holder'); ?></span>
                                                    <span id="finance_holder_<?php echo e($finance->id); ?>" class="data-value"><?php echo e($finance->account_holder_name); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>

                                            <a href="<?php echo e(route('profile.dealers.financial.edit', $finance->id)); ?>" class="data-item" async-modal data-method="post">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.financial_information.account_number'); ?></span>
                                                    <span id="finance_account_<?php echo e($finance->id); ?>" class="data-value"><?php echo e($finance->account_number); ?></span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="data-item">
                                                <div class="data-col"><span class="data-value"><?php echo e(trans('global.text.not_available')); ?></span></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <div class="tab-pane" id="business-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title"><?php echo app('translator')->get('profile.business_information.title'); ?></h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="<?php echo e(route('profile.dealers.business.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.business_information.operations'); ?></span>
                                                <span class="data-value">
                                                    <?php $__empty_1 = true; $__currentLoopData = $dealer->operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <div id="operation_<?php echo e($op->id); ?>"><?php echo e($op->operation); ?></div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <?php echo e(trans('global.text.not_available')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <?php if($dealer->branches->count()): ?>
                                            <?php $__currentLoopData = $dealer->branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('profile.dealers.business.edit', $branch->id)); ?>" class="data-item" async-modal data-method="post">
                                                    <div class="data-col">
                                                        <span class="data-label"><?php echo app('translator')->get('profile.business_information.branch_name'); ?></span>
                                                        <span id="branch_name_<?php echo e($branch->id); ?>"
                                                            class="data-value"><?php echo e($branch->branch_name ?? trans('global.text.not_available')); ?></span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <div class="data-item">
                                                <div class="data-col">
                                                    <span class="data-label"><?php echo app('translator')->get('profile.business_information.branches'); ?></span>
                                                    <span id="branches_count" class="data-value"><?php echo e(trans('global.text.not_available')); ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <a href="<?php echo e(route('profile.dealers.business.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.business_information.website'); ?></span>
                                                <span id="website_links" class="data-value"><?php echo e($dealer->website ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>
                                    </div>
                                </div>

                                
                                <div class="tab-pane" id="documents-info">
                                    <div class="nk-block-head nk-block-head-lg pb-0">
                                        <h4 class="nk-block-title"><?php echo app('translator')->get('profile.documents_information.title'); ?></h4>
                                    </div>

                                    <div class="nk-data data-list">
                                        <a href="<?php echo e(route('profile.dealers.documents.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.documents_information.business_license'); ?></span>
                                                <span id="doc_business_license" class="data-value">
                                                    <?php echo e($dealer->media->where('type', 'business_license')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available')); ?>

                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.documents.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.documents_information.tax_certificate'); ?></span>
                                                <span id="doc_tax_certificate" class="data-value">
                                                    <?php echo e($dealer->media->where('type', 'tax_certificate')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available')); ?>

                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.documents.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.documents_information.bank_statement'); ?></span>
                                                <span id="doc_bank_statement" class="data-value">
                                                    <?php echo e($dealer->media->where('type', 'bank_statement')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available')); ?>

                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.documents.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.documents_information.constitution'); ?></span>
                                                <span id="doc_constitution" class="data-value">
                                                    <?php echo e($dealer->media->where('type', 'constitution')->count() ? trans('profile.documents_information.view_uploaded') : trans('global.text.not_available')); ?>

                                                </span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>

                                        <a href="<?php echo e(route('profile.dealers.documents.edit')); ?>" class="data-item" async-modal data-method="post">
                                            <div class="data-col">
                                                <span class="data-label"><?php echo app('translator')->get('profile.documents_information.swift'); ?></span>
                                                <span id="doc_swift" class="data-value"><?php echo e($dealer->bank_swift ?? trans('global.text.not_available')); ?></span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </a>
                                    </div>
                                </div>

                            </div> 
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        const notAvailableText = "<?php echo e(trans('global.text.not_available')); ?>";

        $(document).on('click', '.nav-link', function(e) {
            e.preventDefault();
            const target = $(this).attr('href');
            $('.nav-link').removeClass('active');
            $('.tab-pane').removeClass('active');
            $(this).addClass('active');
            $(target).addClass('active');
        });

        $(document).on('profile.updated', function(e, params) {
            for (const key in params) {
                const value = params[key] ?? notAvailableText;
                const $el = $(`#${key}`);
                if ($el.length) $el.text(value);
                if (key === 'name' || key === 'fullName') {
                    $('.auth-name').text(value);
                }
            }
        });

        $(document).on('avatar.updated', function(e, params) {
            if (params?.url) {
                $('body').find('.auth-avatar').find('img').attr('src', params.url).show().siblings('span').hide();
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/profile/dealers/index.blade.php ENDPATH**/ ?>