<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Find your perfect vehicle - Browse our extensive collection of quality vehicles from trusted dealers'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_keywords', 'vehicles, cars, buy car, sell car, dealers'); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $__env->yieldContent('meta_title', config('app.name')); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('meta_description', 'Find your perfect vehicle'); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="<?php echo $__env->yieldContent('meta_title', config('app.name')); ?>">
    <meta property="twitter:description" content="<?php echo $__env->yieldContent('meta_description', 'Find your perfect vehicle'); ?>">

    <title><?php echo $__env->yieldContent('meta_title', 'Home'); ?> | <?php echo e(config('app.name')); ?></title>

    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">

    <!-- Google Fonts - Preconnect for faster loading -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <!-- Google Fonts - Poppins, Impact, Urbanist (Synchronous load for immediate availability) -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">    <style>
        /* Ensure fonts are applied correctly - Load immediately */
        body {
            font-family: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif !important;
        }

        .buyer-header-menu {
            font-family: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif !important;
        }

        .buyer-hero-tagline {
            font-family: 'Urbanist', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif !important;
        }

        .buyer-hero-title {
            font-family: 'Impact', 'Arial Black', 'Arial Bold', sans-serif !important;
        }
    </style>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/buyer.css']); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldContent('page-styles'); ?>

    <?php echo $__env->yieldPushContent('vue-scripts'); ?>
</head>

<body class="antialiased bg-black">
    <div id="buyer-app" class="max-w-[1920px] mx-auto bg-white">
        <?php echo $__env->make('buyer.components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    <script>
        // Pass any initial data to Vue if needed
        window.Laravel = {
            csrfToken: '<?php echo e(csrf_token()); ?>',
            apiUrl: '<?php echo e(url('/api')); ?>',
        };
    </script>
</body>
</html>

<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/layouts/buyer/app.blade.php ENDPATH**/ ?>