<?php $__env->startSection('title', 'Dx-Customers Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title branch-title"><?php echo app('translator')->get('dx-customer.page.heading'); ?></h3>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dx-customer.branch.add')): ?>
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="branchMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="branchMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="<?php echo e(route('dx-customers.create')); ?>" class="form-control btn btn-primary" async-modal async-modal-size="lg">
                                            <em class="icon ni ni-plus"></em>
                                            <span><?php echo app('translator')->get('dx-customer.page.button.add'); ?></span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-preview">
            <div class="card-inner">
                <table id="dx-customer-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th><span class="sub-text">#</span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dx-customer.table.header.customer_name'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dx-customer.table.header.status'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dx-customer.table.header.created'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dx-customer.table.header.updated'); ?></span></th>
                            <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('dx-customer.table.header.actions'); ?></span></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let columns = [
            {
                data: 'DT_RowIndex',
                name: 'uuid',
                orderable: false,
                searchable: false,
            },
            {
                data: 'customer_name',
                name: 'customer_name',
            },
            {
                data: 'status',
                name: 'status',
            },
            {
                data: 'created',
                name: 'created',
                searchable: false,
            },
            {
                data: 'updated',
                name: 'updated',
                searchable: false,
            },
            {
                data: 'actions',
                name: 'actions',
                searchable: false,
            },
        ];

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        let dt = $('#dx-customer-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "<?php echo e(route('dx-customers.datatable')); ?>",
                type: "GET", // you can use POST if your route expects it
                dataType: "json",
                error: function (xhr, error, thrown) {
                    console.error('DataTable AJAX error:', xhr.responseText);
                    if (xhr.status === 401) {
                        alert('Session expired. Please log in again.');
                        window.location.reload();
                    }
                }
            },
            columns: columns,
        });

        $('#branches-dt').on('draw.dt', function() {
            let queryString = new URLSearchParams({
                search: $('[type="search"]').val(),
            }).toString();
            console.log('Search Query:', queryString);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dx-customers/index.blade.php ENDPATH**/ ?>