<link rel="stylesheet" href="<?php echo e(asset('assets/css/summernote-3.2.3.css')); ?>">

<?php $url = isset($customer) ? route('dx-customers.update', $customer->uuid) : route('dx-customers.store'); ?>

<h5 class="title pb-3"><?php echo e(isset($customer) ? 'Update' : 'Add New'); ?> Dx Customer</h5>

<form action="<?php echo e($url); ?>" method="post" async-form on-async-modal data-datatable="#dx-customer-dt">
    <?php echo csrf_field(); ?>

    <?php if(isset($customer)): ?>
        <?php echo method_field('put'); ?>
    <?php endif; ?>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="customer_name"><?php echo app('translator')->get('dx-customer.form.name.label'); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="customer_name" name="customer_name" placeholder="<?php echo app('translator')->get('dx-customer.form.name.placeholder'); ?>" required value="<?php echo e(old('customer_name', isset($customer) ? $customer->customer_name : '')); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary"><?php echo e(isset($customer) ? 'Update' : 'Add'); ?></button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="<?php echo e(asset('assets/js/summernote-3.2.3.js')); ?>"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dx-customers/modals/form.blade.php ENDPATH**/ ?>