<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta name="author" content="TRS">
    <meta name="description" content="Exercises are structured in adventures with progressive unlocking.">

    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(config('app.name')); ?></title>

    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>" type="image/x-icon">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/theme.min.css?ver=3.2.3')); ?>">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="nk-body ui-rounder npc-default pg-auth">
    <!-- app-root @s -->
    <div class="nk-app-root">
        <div class="nk-main">
            <!-- wrap @s -->
            <div class="nk-wrap nk-wrap-nosidebar">
                <!-- content @s -->
                <div class="nk-content ">
                    <div class="nk-block nk-block-middle nk-auth-body <?php echo e(isset($cardWidth) ? $cardWidth : 'wide-xs'); ?>">


                        <?php echo $__env->yieldContent('content'); ?>
                    </div>

                    <?php echo $__env->make('layouts.auth.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <!-- content @e -->
            </div>
            <!-- wrap @e -->
        </div>
    </div>
    <!-- app-root @e -->

    <!-- JavaScript -->
    <script>
        let hoursTranslation = "<?php echo e(trans('global.time-hours')); ?>";
        let minutesTranslation = "<?php echo e(trans('global.time-minutes')); ?>";

        let tableBodyNoDataAvailableText = "<?php echo e(trans('global.table.body.no_data_available')); ?>";
        let tableBodyNoMatchingRecordsFoundText = "<?php echo e(trans('global.table.body.no_matching_records_found')); ?>";
        let tableFooterShowingText = "<?php echo e(trans('global.table.footer.showing')); ?>";
        let tableFooterToText = "<?php echo e(trans('global.table.footer.to')); ?>";
        let tableFooterOfText = "<?php echo e(trans('global.table.footer.of')); ?>";
        let tableFooterEntriesText = "<?php echo e(trans('global.table.footer.entries')); ?>";

        let tableFooterPaginationPreviousButtonText = "<?php echo e(trans('global.table.footer.pagination.button.previous')); ?>";
        let tableFooterPaginationNextButtonText = "<?php echo e(trans('global.table.footer.pagination.button.next')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/js/bundle.js?ver=3.2.3')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scripts.js?ver=3.2.3')); ?>"></script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/layouts/auth/app.blade.php ENDPATH**/ ?>