<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['listing']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['listing']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $spec = $listing->specification;
    $mainImage = $listing->image_url && is_array($listing->image_url) && count($listing->image_url) > 0 
        ? $listing->image_url[0] 
        : asset('assets/images/placeholder.png');
    $dealerName = $listing->owner ? ($listing->owner->first_name . ' ' . $listing->owner->last_name) : 'N/A';
    $addedDate = $listing->created_at ? $listing->created_at->format('d.m.y') : 'N/A';
?>

<article class="product-card">
    <a href="<?php echo e(route('buyer.index')); ?>#listing-<?php echo e($listing->uuid); ?>" class="product-card-link">
        <!-- Car Image -->
        <div class="product-card-image">
            <img 
                src="<?php echo e($mainImage); ?>" 
                alt="<?php echo e($listing->title); ?>"
                class="product-card-img"
            >
        </div>

        <!-- Card Content -->
        <div class="product-card-content">
            <!-- Title and Price Row -->
            <div class="product-card-header">
                <h3 class="product-card-title"><?php echo e($listing->title); ?></h3>
                <p class="product-card-price">$<?php echo e(number_format($listing->price, 0)); ?></p>
            </div>

            <!-- Body Type and Year -->
            <div class="product-card-basic-info">
                <?php if($spec?->body_type): ?>
                    <span><?php echo e($spec->body_type); ?></span>
                <?php endif; ?>
                <?php if($spec?->year): ?>
                    <span class="product-card-separator">•</span>
                    <span><?php echo e($spec->year); ?></span>
                <?php endif; ?>
            </div>

            <!-- Dashed Separator -->
            <div class="product-card-divider"></div>

            <!-- Specifications Grid -->
            <div class="product-card-specs">
                <!-- Mileage -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="<?php echo e(asset('assets/buyer/product/speedometer.svg')); ?>" alt="Mileage" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        <?php echo e($spec?->mileage ? number_format($spec->mileage) : '0'); ?>

                    </span>
                </div>

                <!-- Engine -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="<?php echo e(asset('assets/buyer/product/fa_gears.svg')); ?>" alt="Engine" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        <?php echo e($spec?->engine_capacity ? ($spec->engine_capacity / 1000) . 'L' : 'N/A'); ?>

                        <?php if($spec?->engine_capacity && $spec->engine_capacity >= 3000): ?>
                            Twinscroll
                        <?php endif; ?>
                    </span>
                </div>

                <!-- Fuel Type -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="<?php echo e(asset('assets/buyer/product/fuel.svg')); ?>" alt="Fuel Type" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        <?php echo e($spec?->fuel_type ?: 'N/A'); ?>

                    </span>
                </div>

                <!-- Transmission -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="<?php echo e(asset('assets/buyer/product/car_type.svg')); ?>" alt="Transmission" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        <?php echo e($spec?->transmission ?: 'N/A'); ?>

                    </span>
                </div>
            </div>

            <!-- Dashed Separator -->
            <div class="product-card-divider"></div>

            <!-- Footer Info -->
            <div class="product-card-footer">
                <div class="product-card-footer-item">
                    <span class="product-card-footer-label">City:</span>
                    <span class="product-card-footer-value"><?php echo e($listing->location ?: 'N/A'); ?></span>
                </div>
                <div class="product-card-footer-item">
                    <span class="product-card-footer-label">Agent:</span>
                    <span class="product-card-footer-value"><?php echo e($dealerName); ?></span>
                </div>
                <div class="product-card-footer-item">
                    <span class="product-card-footer-label">Added:</span>
                    <span class="product-card-footer-value"><?php echo e($addedDate); ?></span>
                </div>
            </div>
        </div>
    </a>
</article>

<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/buyer/components/product-card.blade.php ENDPATH**/ ?>