<h5 class="title pb-3"><?php echo app('translator')->get('users.modal.header.edit.title'); ?></h5>

<form action="<?php echo e(route('users.update', $user->uuid)); ?>" method="post" async-form on-async-modal data-datatable="#users-dt">
    <?php echo csrf_field(); ?>
    <?php echo method_field('put'); ?>

    <div class="col-md-12 mb-3">
        <div class="form-group">
            <label class="form-label" for="first_name"><?php echo app('translator')->get('users.form.first_name.label'); ?></label>
            <input class="form-control form-control-lg" id="first_name" name="first_name" placeholder="<?php echo app('translator')->get('users.form.first_name.placeholder'); ?>" value="<?php echo e($user->first_name); ?>">
            <span class="invalid-feedback" role="alert"></span>
        </div>
    </div>

    <div class="col-md-12 mb-3">
        <div class="form-group">
            <label class="form-label" for="last_name"><?php echo app('translator')->get('users.form.last_name.label'); ?></label>
            <input class="form-control form-control-lg" id="last_name" name="last_name" placeholder="<?php echo app('translator')->get('users.form.last_name.placeholder'); ?>" value="<?php echo e($user->last_name); ?>">
            <span class="invalid-feedback" role="alert"></span>
        </div>
    </div>

    <div class="col-md-12 mb-3">
        <div class="form-group">
            <label class="form-label" for="phone"><?php echo app('translator')->get('users.form.phone.label'); ?></label>
            <input class="form-control form-control-lg" id="phone" name="phone" placeholder="<?php echo app('translator')->get('users.form.phone.placeholder'); ?>" value="<?php echo e($user->phone); ?>">
            <span class="invalid-feedback" role="alert"></span>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-md-6">
            <div class="custom-control custom-switch checked mb-3">
                <input type="checkbox" class="custom-control-input" name="status" id="status" value="true" <?php if($user->status === \App\Enum\Status::ACTIVE): echo 'checked'; endif; ?>>
                <label class="custom-control-label" for="status"><?php echo app('translator')->get('users.form.active.label'); ?></label>
            </div>
            <span class="invalid-feedback" role="alert"></span>
        </div>

        <div class="col-md-12 mb-3">
            <div class="form-group">
                <label class="form-label" for="comments"><?php echo app('translator')->get('users.form.comments.label'); ?></label>
                <textarea class="form-control form-control-lg" id="comments" name="comments" placeholder="<?php echo app('translator')->get('users.form.comments.placeholder'); ?>"><?php echo e($user->admin_comments); ?></textarea>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary"><?php echo app('translator')->get('global.form.button.update'); ?></button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close><?php echo app('translator')->get('global.form.button.cancel'); ?></button></li>
            </ul>
        </div>
    </div>
</form>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/users/modals/edit.blade.php ENDPATH**/ ?>