<?php $__env->startSection('title', trans('login.page.title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title"><?php echo app('translator')->get('login.page.heading'); ?></h4>
                    <div class="nk-block-des">
                        <p><?php echo app('translator')->get('login.page.description'); ?></p>
                    </div>
                </div>
            </div>

            <?php if(session('status')): ?>
                <div class="alert alert-info"><?php echo e(session('status')); ?></div>
            <?php endif; ?>

            <form method="post" action="<?php echo e(route('dealers.login.store')); ?>">
                <?php echo csrf_field(); ?>

                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="email"><?php echo app('translator')->get('login.form.email.label'); ?></label>
                    </div>
                    <div class="form-control-wrap">
                        <input type="email" class="form-control form-control-lg" id="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus
                            placeholder="<?php echo app('translator')->get('login.form.email.placeholder'); ?>">
                        <?php if($errors->has('email')): ?>
                            <small class="text-danger"><?php echo e($errors->first('email')); ?></small>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="password"><?php echo app('translator')->get('login.form.password.label'); ?></label>
                        <?php if(Route::has('dealers.password.request')): ?>
                            <a class="link link-primary link-sm" href="<?php echo e(route('dealers.password.request')); ?>" tabindex="-1"><?php echo app('translator')->get('login.page.question.forgot_password'); ?></a>
                        <?php endif; ?>
                    </div>
                    <div class="form-control-wrap">
                        <a href="javascript:void(0);" class="form-icon form-icon-right passcode-switch lg" data-target="password" tabindex="-1">
                            <em class="passcode-icon icon-show icon ni ni-eye"></em>
                            <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                        </a>
                        <input type="password" class="form-control form-control-lg" id="password" name="password" required placeholder="<?php echo app('translator')->get('login.form.password.placeholder'); ?>">
                        <?php if($errors->has('password')): ?>
                            <small class="text-danger"><?php echo e($errors->first('password')); ?></small>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="my-3">
                    <div class="form-group m-0">
                        <div class="custom-control custom-control-xs custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="terms" id="terms">
                            <label class="custom-control-label" for="terms"><?php echo app('translator')->get('login.page.checkbox.terms_and_conditions.accept'); ?></label>
                        </div>
                    </div>
                    <?php if($errors->has('terms')): ?>
                        <small class="text-danger"><?php echo e($errors->first('terms')); ?></small>
                    <?php endif; ?>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-control-xs custom-checkbox">
                        <input type="checkbox" class="custom-control-input" name="remember" id="remember">
                        <label class="custom-control-label" for="remember"><?php echo app('translator')->get('login.page.checkbox.remember_me'); ?></label>
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-lg btn-primary btn-block"><?php echo app('translator')->get('login.page.buttons.login'); ?></button>
                </div>
            </form>
            <?php if(Route::has('dealers.register')): ?>
                <div class="form-note-s2 text-center pt-4">
                    <?php echo app('translator')->get('login.page.question.register'); ?> <a href="<?php echo e(route('dealers.register')); ?>"><?php echo app('translator')->get('login.page.buttons.register'); ?></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dealer/auth/login.blade.php ENDPATH**/ ?>