        
        <h5 class="mb-3">1. Company Information</h5>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Company Name</label>
                <p class="form-control-plaintext"><?php echo canEmpty($dealer->company_name); ?></p>
            </div>
            <div class="col-md-6">
                <label class="form-label">Registration / License Number</label>
                <p class="form-control-plaintext"><?php echo canEmpty($dealer->registration_number); ?></p>
            </div>
            <div class="col-md-6">
                <label class="form-label">Tax Identification Number (NTN)</label>
                <p class="form-control-plaintext"><?php echo canEmpty($dealer->tax_identification_number); ?></p>
            </div>

            <?php if($dealer->addresses->isNotEmpty()): ?>
                <?php $addr = $dealer->addresses->first(); ?>
                <div class="col-md-4">
                    <label class="form-label">Country</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($addr->country); ?></p>
                </div>
                <div class="col-md-4">
                    <label class="form-label">State / Province</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($addr->state); ?></p>
                </div>
                <div class="col-md-4">
                    <label class="form-label">City</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($addr->city); ?></p>
                </div>
                <div class="col-md-8">
                    <label class="form-label">Street Address</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($addr->street); ?></p>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Postal Code</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($addr->postal_code); ?></p>
                </div>
            <?php endif; ?>

            <div class="col-md-6">
                <label class="form-label">Contact Phone</label>
                <p class="form-control-plaintext"><?php echo canEmpty(optional($dealer->user)->phone); ?></p>
            </div>
            <div class="col-md-6">
                <label class="form-label">Contact Email</label>
                <p class="form-control-plaintext"><?php echo canEmpty(optional($dealer->user)->email); ?></p>
            </div>
        </div>

        <hr class="my-4">

        
        <h5 class="mb-3">2. Authorized Representative Information</h5>
        <?php if($dealer->representatives->isNotEmpty()): ?>
            <?php $rep = $dealer->representatives->first(); ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Full Name</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($rep->full_name); ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">CNIC / Passport</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($rep->nic_number); ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Position</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($rep->position); ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Representative Contact</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($rep->contact_phone); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <hr class="my-4">

        
        <h5 class="mb-3">3. Bank & Financial Information</h5>
        <?php if($dealer->finances->isNotEmpty()): ?>
            <?php $finance = $dealer->finances->first(); ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Bank Name</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($finance->name); ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Account Holder Name</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($finance->account_holder_name); ?></p>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Account Number / IBAN</label>
                    <p class="form-control-plaintext"><?php echo canEmpty($finance->account_number); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <hr class="my-4">

        
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Status</label>
                <p class="form-control-plaintext"><?php echo $dealer->user->getStatusBadge(); ?></p>
            </div>
            <div class="col-md-4">
                <label class="form-label">Created At</label>
                <p class="form-control-plaintext"><?php echo createdAt($dealer, isHumanTime: false); ?></p>
            </div>
            <div class="col-md-4">
                <label class="form-label">Updated At</label>
                <p class="form-control-plaintext"><?php echo updatedAt($dealer, isHumanTime: false); ?></p>
            </div>
        </div>

        <hr class="my-4">

        
        <h5 class="mb-3">Dealer Listings</h5>
        <?php if($dealer->user && $dealer->user->listings->isNotEmpty()): ?>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Price</th>
                            <th>Location</th>
                            <th>Type</th>
                            <th>Status</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $dealer->user->listings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($listing->title); ?></td>
                                <td>$<?php echo e(number_format($listing->price, 2)); ?></td>
                                <td><?php echo e($listing->location); ?></td>
                                <td><?php echo e(ucfirst($listing->type)); ?></td>
                                <td><?php echo $listing->status->badge(); ?></td>
                                <td><?php echo e($listing->created_at->format('d M Y')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-muted">No listings found for this dealer.</p>
        <?php endif; ?>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dealers/modals/show.blade.php ENDPATH**/ ?>