<link rel="stylesheet" href="<?php echo e(asset('assets/css/summernote-3.2.3.css')); ?>">

<?php $url = isset($dexUser) ? route('dex-users.update', $dexUser->uuid) : route('dex-users.store'); ?>

<h5 class="title pb-3"><?php echo e(isset($dexUser) ? 'Update' : 'Add New'); ?> Dex User</h5>

<form action="<?php echo e($url); ?>" method="post" async-form on-async-modal data-datatable="#dex-user-dt">
    <?php echo csrf_field(); ?>

    <?php if(isset($dexUser)): ?>
        <?php echo method_field('put'); ?>
    <?php endif; ?>

    <div class="row gy-4">

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="first_name"><?php echo app('translator')->get('dex-user.form.first_name.label'); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="first_name" name="first_name" placeholder="<?php echo app('translator')->get('dex-user.form.first_name.placeholder'); ?>" required value="<?php echo e(isset($dexUser) ? $dexUser->first_name : ''); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="last_name"><?php echo app('translator')->get('dex-user.form.last_name.label'); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="last_name" name="last_name" placeholder="<?php echo app('translator')->get('dex-user.form.last_name.placeholder'); ?>" required value="<?php echo e(isset($dexUser) ? $dexUser->last_name : ''); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="email"><?php echo app('translator')->get('dex-user.form.email.label'); ?> <span class="text-danger">*</span></label>
                <input type="email" class="form-control" id="email" name="email" placeholder="<?php echo app('translator')->get('dex-user.form.email.placeholder'); ?>" required value="<?php echo e(isset($dexUser) ? $dexUser->email : ''); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary"><?php echo e(isset($dexUser) ? 'Update' : 'Add'); ?></button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="<?php echo e(asset('assets/js/summernote-3.2.3.js')); ?>"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dex-users/modals/form.blade.php ENDPATH**/ ?>