<?php $__env->startSection('title', 'Taxes Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title tax-title"><?php echo app('translator')->get('tax.page.heading'); ?></h3>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tax.add')): ?>
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="taxMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="taxMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="<?php echo e(route('taxes.create')); ?>" class="form-control btn btn-primary" async-modal async-modal-size="lg">
                                            <em class="icon ni ni-plus"></em>
                                            <span><?php echo app('translator')->get('tax.page.button.add'); ?></span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-preview">
            <div class="card-inner">
                <table id="taxes-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th><span class="sub-text">#</span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('tax.table.header.name'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('tax.table.header.tax'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('tax.table.header.custom-tax'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('tax.table.header.shipping-fee'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('tax.table.header.created'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('tax.table.header.updated'); ?></span></th>
                            <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('tax.table.header.actions'); ?></span></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let columns = [{
                data: 'DT_RowIndex',
                name: 'uuid',
                orderable: false,
                searchable: false,

            },
            {
                data: 'name',
                name: 'name',
            },
            {
                data: 'tax',
                name: 'tax',
            },
            {
                data: 'custom_tax',
                name: 'custom_tax',
            },
            {
                data: 'shipping_fee',
                name: 'shipping_fee',
            },

            {
                data: 'created',
                name: 'created',
                searchable: false
            },
            {
                data: 'updated',
                name: 'updated',
                searchable: false
            },
            {
                data: 'actions',
                name: 'actions',
                searchable: false
            },
        ];

        let dt = $('#taxes-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "<?php echo e(route('taxes.datatable')); ?>",
            },
            columns: columns,
        });

        $('#taxes-dt').on('draw.dt', function() {
            let queryString = new URLSearchParams({
                search: $('[type="search"]').val(),
            }).toString();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/taxes/index.blade.php ENDPATH**/ ?>