<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta name="author" content="TRS">
    <meta name="description" content="Exercises are structured in adventures with progressive unlocking.">

    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(config('app.name')); ?></title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/theme.min.css?ver=3.2.3')); ?>">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <script>
        let fallbackThumbnail = "<?php echo e(asset('assets/images/placeholder.png')); ?>";

        // Bind image on error. ie = Image Error
        function _ie(_self) {
            _self.src = fallbackThumbnail;
        }
    </script>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="nk-body bg-lighter npc-default has-sidebar <?php echo e($isDarkMode ? 'dark-mode' : ''); ?>">
    <div class="nk-app-root">
        <div class="nk-main ">
            <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="nk-wrap ">
                <?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <!-- content @s -->
                <div class="nk-content ">
                    <div class="container-fluid">
                        <div class="nk-content-inner">
                            <div class="nk-content-body">
                                <?php echo $__env->make('layouts.partials.user-notices', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                                <?php echo $__env->yieldContent('content'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- content @e -->

                <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            </div>
        </div>
    </div>
    <!-- app-root @e -->

    <!-- Async modal @s -->
    <div class="modal fade zoom" id="async-modal" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <a href="javascript:void(0);" class="close" async-modal-close>
                    <em class="icon ni ni-cross"></em>
                </a>
                <div class="modal-body modal-body-lg">
                    <div id="content"></div>
                    <div id="spinner">
                        <div class="modal-body text-center">
                            <div class="spinner-border text-center" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Async modal @e -->

    <!-- JavaScript -->
    <script>
        let hoursTranslation = "<?php echo e(trans('global.time-hours')); ?>";
        let minutesTranslation = "<?php echo e(trans('global.time-minutes')); ?>";

        let tableBodyNoDataAvailableText = "<?php echo e(trans('global.table.body.no_data_available')); ?>";
        let tableBodyNoMatchingRecordsFoundText = "<?php echo e(trans('global.table.body.no_matching_records_found')); ?>";
        let tableFooterShowingText = "<?php echo e(trans('global.table.footer.showing')); ?>";
        let tableFooterToText = "<?php echo e(trans('global.table.footer.to')); ?>";
        let tableFooterOfText = "<?php echo e(trans('global.table.footer.of')); ?>";
        let tableFooterEntriesText = "<?php echo e(trans('global.table.footer.entries')); ?>";

        let tableFooterPaginationPreviousButtonText = "<?php echo e(trans('global.table.footer.pagination.button.previous')); ?>";
        let tableFooterPaginationNextButtonText = "<?php echo e(trans('global.table.footer.pagination.button.next')); ?>";
    </script>
    <script src="<?php echo e(asset('assets/js/bundle.js?ver=3.2.3')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scripts.js?ver=3.2.3')); ?>"></script>

    <script>
        $.extend(true, $.fn.dataTable.defaults, {
            oLanguage: {
                sSearch: '',
                sSearchPlaceholder: "<?php echo e(__('global.table.search.placeholder')); ?>",
                sLengthMenu: "<?php echo e(__('global.table.search.pagination.menu')); ?>" + ' _MENU_',
            }
        });

        setTimeout(() => {
            $('.alert-dismisable').slideUp(300);
        }, 3500);
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/layouts/app.blade.php ENDPATH**/ ?>