<article class="bg-white shadow-sm rounded border border-gray-200 hover:shadow-md transition flex flex-col">

    
    <div class="border-b border-gray-200">
        <img src="<?php echo e($car->image_url); ?>" alt="<?php echo e($car->name); ?>" class="w-full h-48 object-cover">
    </div>

    
    <div class="p-4 flex-1 flex flex-col justify-between">
        <div>
            <div class="flex items-start justify-between">
                <div>
                    <h3 class="font-semibold text-gray-900"><?php echo e($car->name); ?></h3>
                    <p class="text-xs text-gray-500"><?php echo e($car->type); ?> • <?php echo e($car->year); ?></p>

                    
                    <div class="border-b border-dotted border-gray-300 my-2"></div>
                </div>
                <span class="font-semibold text-gray-900">$<?php echo e(number_format($car->price)); ?></span>
            </div>

            
            <div class="flex items-center justify-between mt-4 text-gray-600 text-xs">
                <?php $__currentLoopData = $car->specs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex flex-col items-center text-center w-16">
                        <img src="<?php echo e($spec['icon']); ?>" class="w-6 h-6 object-contain mb-1" alt="icon">
                        <span class="text-[10px] leading-tight"><?php echo e($spec['value']); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        
        <footer class="mt-4 flex flex-wrap items-center gap-4 text-xs text-gray-600 border-t border-dotted border-gray-200 pt-3">
            <span><span class="font-semibold text-gray-800">City:</span> <?php echo e($car->city); ?></span>
            <span><span class="font-semibold text-gray-800">Agent:</span> <?php echo e($car->agent); ?></span>
            <span class="text-gray-400">Added: <?php echo e($car->added_at->format('m.d.y')); ?></span>
        </footer>
    </div>
</article>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/buyer/components/car-card.blade.php ENDPATH**/ ?>