<?php $__env->startSection('title', trans('roles.home.page.title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title"><?php echo app('translator')->get('roles.home.page.heading'); ?></h3>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="pageMenu">
                        <em class="icon ni ni-more-v"></em>
                    </a>
                    <?php if(auth()->user()->hasPermissionTo('role.add') || auth()->user()->hasRole('super_admin')): ?>
                        <div class="toggle-expand-content" data-content="pageMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-primary">
                                        <em class="icon ni ni-plus"></em>
                                        <span><?php echo app('translator')->get('roles.home.page.button.create'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-aside-wrap">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#active"><em class="icon ni ni-activity"></em><span><?php echo app('translator')->get('global.table.type.active'); ?></span></a>
                        </li>
                        <?php if(auth()->user()->can('role.delete')): ?>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#archived" id="archived_tab"><em class="icon ni ni-trash"></em><span><?php echo app('translator')->get('global.table.type.deleted'); ?></span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <div class="card-inner position-relative card-tools-toggle table-responsive">
                        <div class="tab-content">
                            <div class="tab-pane active" id="active">
                                <table id="roles-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                                    <thead>
                                        <tr class="nk-tb-item nk-tb-head">
                                            <th><span class="sub-text">#</span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.name'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.total_users'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.total_permissions'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.created'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.updated'); ?></span></th>
                                            <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.actions'); ?></span></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <?php if(auth()->user()->can('role.delete')): ?>
                                <div class="tab-pane" id="archived">
                                    <table id="archived-roles-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                                        <thead>
                                            <tr class="nk-tb-item nk-tb-head">
                                                <th><span class="sub-text">#</span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.name'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.total_users'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.total_permissions'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.created'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.updated'); ?></span></th>
                                                <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('roles.home.table.header.actions'); ?></span></th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        var table = $('#roles-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: "<?php echo e(route('roles.dataTable')); ?>",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'id',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'total_count',
                    name: 'total_count'
                },
                {
                    data: 'total_permissions',
                    name: 'total_permissions'
                },
                {
                    data: 'created',
                    name: 'created'
                },
                {
                    data: 'updated',
                    name: 'updated'
                },
                {
                    data: 'actions',
                    name: 'actions'
                },
            ],
            createdRow: function(row, data, index) {
                $(row).addClass('nk-tb-item');
            }
        });

        var archivedTable;

        $(document).ready(function() {
            <?php if(auth()->user()->can('role.delete')): ?>
                // Reload active table when the "Active" tab is clicked
                $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function(event) {
                    var target = $(event.target).attr("href"); // Get the tab being shown
                    if (target === "#active") {
                        table.ajax.reload();
                    } else if (target === "#archived") {
                        // Initialize the archived table if not already done
                        if (!archivedTable) {
                            archivedTable = $('#archived-roles-dt').DataTable({
                                processing: true,
                                serverSide: true,
                                scrollX: false,
                                ordering: false,
                                autoWidth: true,
                                ajax: "<?php echo e(route('roles.dataTable.archived')); ?>",
                                columns: [{
                                        data: 'DT_RowIndex',
                                        name: 'id',
                                        orderable: false,
                                        searchable: false
                                    },
                                    {
                                        data: 'name',
                                        name: 'name'
                                    },
                                    {
                                        data: 'total_count',
                                        name: 'total_count'
                                    },
                                    {
                                        data: 'total_permissions',
                                        name: 'total_permissions'
                                    },
                                    {
                                        data: 'created',
                                        name: 'created'
                                    },
                                    {
                                        data: 'updated',
                                        name: 'updated'
                                    },
                                    {
                                        data: 'actions',
                                        name: 'actions'
                                    },
                                ],
                                createdRow: function(row, data, index) {
                                    $(row).addClass('nk-tb-item');
                                }
                            });
                        } else {
                            // If already initialized, reload the archived table
                            archivedTable.ajax.reload();
                        }
                    }
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/roles/index.blade.php ENDPATH**/ ?>