<?php $__env->startSection('title', 'Listings'); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">Listings Management</h3>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-aside-wrap">
                <div class="card-content">
                    <div class="card-inner position-relative card-tools-toggle table-responsive">
                        <table id="listings-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer"
                            width="100%">
                            <thead>
                                <tr class="nk-tb-item nk-tb-head">
                                    <th><span class="sub-text">#</span></th>
                                    <th><span class="sub-text">Title</span></th>
                                    <th><span class="sub-text">Owner</span></th>
                                    <th><span class="sub-text">Price</span></th>
                                    <th><span class="sub-text">Location</span></th>
                                    <th><span class="sub-text">Type</span></th>
                                    <th><span class="sub-text">Status</span></th>
                                    <th><span class="sub-text">Created</span></th>
                                    <th class="text-right"><span class="sub-text">Actions</span></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        var table = $('#listings-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "<?php echo e(route('admin.listings.datatable')); ?>",
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'id',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'owner',
                    name: 'owner'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'location',
                    name: 'location'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'created',
                    name: 'created',
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    searchable: false
                },
            ],
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/admin/listings/index.blade.php ENDPATH**/ ?>