<link rel="stylesheet" href="<?php echo e(asset('assets/css/summernote-3.2.3.css')); ?>">

<?php $url = isset($tax) ? route('taxes.update', $tax->uuid) : route('taxes.store'); ?>

<h5 class="title pb-3"><?php echo e(isset($tax) ? 'Update' : 'Add New'); ?> Tax</h5>

<form action="<?php echo e($url); ?>" method="post" async-form on-async-modal data-datatable="#taxes-dt">
    <?php echo csrf_field(); ?>

    <?php if(isset($tax)): ?>
        <?php echo method_field('put'); ?>
    <?php endif; ?>

    <div class="row gy-4">
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="name"><?php echo app('translator')->get('tax.form.name.label'); ?><span class="text-danger">*</span></label>
                <select class="form-control" id="state_id" name="state_id" required>
                <option value="">Select State</option>
                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($state->id); ?>" <?php echo e(isset($tax) && $tax->state_id == $state->id ? 'selected' : ''); ?>>
                        <?php echo e($state->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="tax"><?php echo app('translator')->get('tax.form.tax.label'); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="tax" name="tax" placeholder="<?php echo app('translator')->get('tax.form.tax.placeholder'); ?>" required value="<?php echo e(isset($tax) ? $tax->tax : ''); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="custom_tax"><?php echo app('translator')->get('tax.form.custom_tax.label'); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="custom_tax" name="custom_tax" placeholder="<?php echo app('translator')->get('tax.form.custom_tax.placeholder'); ?>" required value="<?php echo e(isset($tax) ? $tax->custom_tax : ''); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="shipping_fee"><?php echo app('translator')->get('tax.form.shipping_fee.label'); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="shipping_fee" name="shipping_fee" placeholder="<?php echo app('translator')->get('tax.form.shipping_fee.placeholder'); ?>" required value="<?php echo e(isset($tax) ? $tax->shipping_fee : ''); ?>">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary"><?php echo e(isset($tax) ? 'Update' : 'Add'); ?></button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="<?php echo e(asset('assets/js/summernote-3.2.3.js')); ?>"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
<?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/taxes/modals/form.blade.php ENDPATH**/ ?>