<?php $__env->startSection('title', 'DexUsers Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title tax-title"><?php echo app('translator')->get('dex-user.page.heading'); ?></h3>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dex_user.add')): ?>
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="taxMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="taxMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="<?php echo e(route('dex-users.create')); ?>" class="form-control btn btn-primary" async-modal async-modal-size="lg">
                                            <em class="icon ni ni-plus"></em>
                                            <span><?php echo app('translator')->get('dex-user.page.button.add'); ?></span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-preview">
            <div class="card-inner">
                <table id="dex-user-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th><span class="sub-text">#</span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dex-user.table.header.first_name'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dex-user.table.header.last_name'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dex-user.table.header.email'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dex-user.table.header.created'); ?></span></th>
                            <th><span class="sub-text"><?php echo app('translator')->get('dex-user.table.header.updated'); ?></span></th>
                            <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('dex-user.table.header.actions'); ?></span></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let columns = [{
                data: 'DT_RowIndex',
                name: 'uuid',
                orderable: false,
                searchable: false,

            },
            {
                data: 'first_name',
                name: 'first_name',
            },
            {
                data: 'last_name',
                name: 'last_name',
            },
            {
                data: 'email',
                name: 'email',
            },
            {
                data: 'created',
                name: 'created',
                searchable: false
            },
            {
                data: 'updated',
                name: 'updated',
                searchable: false
            },
            {
                data: 'actions',
                name: 'actions',
                searchable: false
            },
        ];

        let dt = $('#dex-user-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "<?php echo e(route('dex-users.datatable')); ?>",
            },
            columns: columns,
        });

        $('#dex-users-dt').on('draw.dt', function() {
            let queryString = new URLSearchParams({
                search: $('[type="search"]').val(),
            }).toString();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dex-users/index.blade.php ENDPATH**/ ?>