<?php $__env->startSection('title', trans('activity-logs.page.title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title"><?php echo app('translator')->get('activity-logs.page.title'); ?></h3>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="pageMenu">
                        <em class="icon ni ni-more-v"></em>
                    </a>
                    <div class="toggle-expand-content" data-content="pageMenu">
                        <ul class="nk-block-tools g-3">
                            <li>
                                <div class="form-group">
                                    <label class="form-label"><?php echo app('translator')->get('activity-logs.page.filters.date.label'); ?>: </label>
                                    <div class="form-control-wrap" style="max-width: 300px;">
                                        <div class="input-daterange date-picker-range input-group" data-date-week-start="6" data-date-today-btn="linked"
                                            data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control" placeholder="yyyy-mm-dd" autocomplete="false" value="<?php echo e(getFirstDay('Y-m-d')); ?>" readonly />
                                            <div class="input-group-addon">—</div>
                                            <input type="text" class="form-control" placeholder="yyyy-mm-dd" autocomplete="false" value="<?php echo e(getLastDay('Y-m-d')); ?>" readonly />
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="form-group">
                                    <label class="form-label" for="log_user"><?php echo app('translator')->get('activity-logs.page.filters.user.label'); ?>: </label>
                                    <select class="form-control form-control-lg select2" name="log_user" id="log_user">
                                        <option value="all" selected><?php echo app('translator')->get('activity-logs.page.filters.user.select_option'); ?></option>
                                        <?php $__currentLoopData = $logUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($logUser->user?->uuid); ?>"><?php echo e($logUser->user?->full_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </li>
                            <li class="d-none">
                                <div class="form-group">
                                    <label class="form-label" for="log_module"><?php echo app('translator')->get('activity-logs.page.filters.module.label'); ?>: </label>
                                    <select class="form-control form-control-lg select2" name="log_module" id="log_module">
                                        <option value="all" selected><?php echo app('translator')->get('activity-logs.page.filters.module.select_option'); ?></option>
                                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($module->module); ?>"><?php echo e(str_replace('_', ' ', $module->module)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </li>
                            <li class="d-none">
                                <div class="form-group">
                                    <label class="form-label" for="activity_key"><?php echo app('translator')->get('activity-logs.page.filters.activity.label'); ?>: </label>
                                    <select class="form-control form-control-lg select2" name="activity_key" id="activity_key">
                                        <option value="all" selected><?php echo app('translator')->get('activity-logs.page.filters.activity.select_option'); ?></option>
                                        <?php $__currentLoopData = $logKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($logKey->activity); ?>"><?php echo e(str_replace('_', ' ', $logKey->activity)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-inner-group">
                <div class="card-inner position-relative card-tools-toggle table-responsive">
                    <div class="text-end mb-3">
                        <a href="javascript:void(0);" class="btn btn-sm btn-light" id="toggleColumn">
                            <em class="icon ni ni-eye"></em>
                            <span><?php echo app('translator')->get('activity-logs.page.buttons.user_agent_column.show'); ?></span>
                        </a>
                    </div>
                    <table id="activity-logs-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.user'); ?></span></th>
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.role'); ?></span></th>
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.module'); ?></span></th>
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.activity'); ?></span></th>
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.ip'); ?></span></th>
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.user_agent'); ?></span></th>
                                <th><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.description'); ?></span></th>
                                <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('activity-logs.table.header.labels.activity_performed_at'); ?></span></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let filterModuleSelectOption = "<?php echo e(trans('activity-logs.page.filters.module.select_option')); ?>"
        let filterActivitySelectOption = "<?php echo e(trans('activity-logs.page.filters.activity.select_option')); ?>";
        let showUserAgent = "<?php echo e(trans('activity-logs.page.buttons.user_agent_column.show')); ?>";
        let hideUserAgent = "<?php echo e(trans('activity-logs.page.buttons.user_agent_column.hide')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/js/activity-logs/activity-logs.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/activity-logs/index.blade.php ENDPATH**/ ?>