<?php $__env->startSection('title', 'Listing Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">Listing Details</h3>
                <p class="text-soft"><?php echo e($listing->title); ?></p>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="pageMenu"><em class="icon ni ni-more-v"></em></a>
                    <div class="toggle-expand-content" data-content="pageMenu">
                        <ul class="nk-block-tools g-3">
                            <li>
                                <a href="<?php echo e(route('dealers.listings.edit', $listing->id)); ?>" class="btn btn-primary">
                                    <em class="icon ni ni-edit"></em>
                                    <span>Edit Listing</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('dealers.listings.index')); ?>" class="btn btn-outline-light">
                                    <em class="icon ni ni-arrow-left"></em>
                                    <span>Back to Listings</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="row g-4">
            
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">1. Basic Information</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Make</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->make ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Model</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->model ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Year</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->year ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Trim / Edition</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->trim ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">VIN Code</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->vin ?? 'N/A'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">2. Technical Specifications</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Engine Capacity</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->engine_capacity ?? 'N/A'); ?> cc</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Fuel Type</label>
                                <p class="form-control-plaintext"><?php echo e(ucfirst($listing->specification?->fuel_type ?? 'N/A')); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Transmission</label>
                                <p class="form-control-plaintext"><?php echo e(ucfirst($listing->specification?->transmission ?? 'N/A')); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Drive Type</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->drive_type ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Mileage</label>
                                <p class="form-control-plaintext"><?php echo e(number_format($listing->specification?->mileage ?? 0)); ?> miles</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">3. Body and Exterior</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Body Type</label>
                                <p class="form-control-plaintext"><?php echo e(ucfirst($listing->specification?->body_type ?? 'N/A')); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Exterior Color</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->exterior_color ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Interior Color</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->interior_color ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Number of Seats</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->seats ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Number of Doors</label>
                                <p class="form-control-plaintext"><?php echo e($listing->specification?->doors ?? 'N/A'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">4. Price and Financing</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Price</label>
                                <p class="form-control-plaintext">$<?php echo e(number_format($listing->price, 2)); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Financing Options</label>
                                <p class="form-control-plaintext">
                                    <?php if($listing->financing_options && count($listing->financing_options) > 0): ?>
                                        <?php echo e(implode(', ', array_map('ucfirst', $listing->financing_options))); ?>

                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">5. Features and Options</h5>
                        <?php if($listing->features && $listing->features->count() > 0): ?>
                            <?php
                                $safetyFeatures = $listing->features->where('category', 'safety');
                                $comfortFeatures = $listing->features->where('category', 'comfort');
                                $entertainmentFeatures = $listing->features->where('category', 'entertainment');
                            ?>

                            <?php if($safetyFeatures->count() > 0): ?>
                                <div class="mb-3">
                                    <strong>Safety Features:</strong>
                                    <div class="mt-2">
                                        <?php $__currentLoopData = $safetyFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-success me-1 mb-1"><?php echo e($feature->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if($comfortFeatures->count() > 0): ?>
                                <div class="mb-3">
                                    <strong>Comfort Features:</strong>
                                    <div class="mt-2">
                                        <?php $__currentLoopData = $comfortFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-info me-1 mb-1"><?php echo e($feature->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if($entertainmentFeatures->count() > 0): ?>
                                <div class="mb-3">
                                    <strong>Entertainment Features:</strong>
                                    <div class="mt-2">
                                        <?php $__currentLoopData = $entertainmentFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-primary me-1 mb-1"><?php echo e($feature->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <p class="text-muted">No features listed</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">6. Additional Information</h5>
                        <div class="row g-3">
                            <div class="col-md-12">
                                <label class="form-label">Listing Title</label>
                                <p class="form-control-plaintext"><?php echo e($listing->title); ?></p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Location</label>
                                <p class="form-control-plaintext"><?php echo e($listing->location); ?></p>
                            </div>
                            <?php if($listing->description): ?>
                                <div class="col-md-12">
                                    <label class="form-label">Description</label>
                                    <p class="form-control-plaintext"><?php echo e($listing->description); ?></p>
                                </div>
                            <?php endif; ?>
                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <p class="form-control-plaintext"><?php echo $listing->status->badge(); ?></p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Created At</label>
                                <p class="form-control-plaintext"><?php echo e($listing->created_at->format('d M Y, h:i A')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <?php if($listing->image_url && count($listing->image_url) > 0): ?>
                <div class="col-12">
                    <div class="card card-bordered">
                        <div class="card-inner">
                            <h5 class="card-title">7. Vehicle Images</h5>
                            <div class="row g-3">
                                <?php $__currentLoopData = $listing->image_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4">
                                        <div class="card">
                                            <img src="<?php echo e($image); ?>" alt="Listing Image" class="card-img-top" style="height: 250px; object-fit: cover;">
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dealer.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/dealer/listings/show.blade.php ENDPATH**/ ?>