<?php $__env->startSection('title', trans('buyers.page.title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title"><?php echo app('translator')->get('buyers.page.heading'); ?></h3>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin.buyer.add')): ?>
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="pageMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="pageMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="<?php echo e(route('buyers.create')); ?>" class="form-control btn btn-primary" async-modal data-datatable="#buyers-dt>
                                            <em class="icon ni ni-plus"></em>
                                            <span><?php echo app('translator')->get('buyers.page.button.invite'); ?></span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-aside-wrap">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#active"><em class="icon ni ni-activity"></em><span><?php echo app('translator')->get('global.table.type.active'); ?></span></a>
                        </li>
                        <?php if(auth()->user()->can('role.delete')): ?>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#archived" id="archived_tab"><em class="icon ni ni-trash"></em><span><?php echo app('translator')->get('global.table.type.deleted'); ?></span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <div class="card-inner position-relative card-tools-toggle table-responsive">
                        <div class="tab-content">
                            <div class="tab-pane active" id="active">
                                <table id="buyers-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                                    <thead>
                                        <tr class="nk-tb-item nk-tb-head">
                                            <th><span class="sub-text">#</span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.name'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.phone'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.status'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.comments'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.created'); ?></span></th>
                                            <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.updated'); ?></span></th>
                                            <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.actions'); ?></span></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <?php if(auth()->user()->can('role.delete')): ?>
                                <div class="tab-pane" id="archived">
                                    <table id="archived-buyers-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                                        <thead>
                                            <tr class="nk-tb-item nk-tb-head">
                                                <th><span class="sub-text">#</span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.name'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.phone'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.status'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.comments'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.created'); ?></span></th>
                                                <th><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.updated'); ?></span></th>
                                                <th class="text-right"><span class="sub-text"><?php echo app('translator')->get('buyers.table.header.actions'); ?></span></th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        var table = $('#buyers-dt').DataTable({
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "<?php echo e(route('buyers.datatable')); ?>",
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'uuid',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'comments',
                    name: 'comments',
                    searchable: false
                },
                {
                    data: 'created',
                    name: 'created',
                    searchable: false
                },
                {
                    data: 'updated',
                    name: 'updated',
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    searchable: false
                },
            ],
        });

        var archivedTable;

        $(document).ready(function() {
            <?php if(auth()->user()->can('buyers.delete')): ?>
                // Reload active table when the "Active" tab is clicked
                $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function(event) {
                    var target = $(event.target).attr("href"); // Get the tab being shown
                    if (target === "#active") {
                        table.ajax.reload();
                    } else if (target === "#archived") {
                        // Initialize the archived table if not already done
                        if (!archivedTable) {
                            archivedTable = $('#archived-buyers-dt').DataTable({
                                processing: true,
                                serverSide: true,
                                scrollX: false,
                                ordering: false,
                                autoWidth: true,
                                ajax: "<?php echo e(route('buyers.datatable.archived')); ?>",
                                columns: [{
                                        data: 'DT_RowIndex',
                                        name: 'uuid',
                                        orderable: false,
                                        searchable: false
                                    },
                                    {
                                        data: 'name',
                                        name: 'name'
                                    },
                                    {
                                        data: 'phone',
                                        name: 'phone'
                                    },
                                    {
                                        data: 'status',
                                        name: 'status'
                                    },
                                    {
                                        data: 'comments',
                                        name: 'comments',
                                        searchable: false
                                    },
                                    {
                                        data: 'created',
                                        name: 'created',
                                        searchable: false
                                    },
                                    {
                                        data: 'updated',
                                        name: 'updated',
                                        searchable: false
                                    },
                                    {
                                        data: 'actions',
                                        name: 'actions',
                                        searchable: false
                                    },
                                ],
                                createdRow: function(row, data, index) {
                                    $(row).addClass('nk-tb-item');
                                }
                            });
                        } else {
                            // If already initialized, reload the archived table
                            archivedTable.ajax.reload();
                        }
                    }
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\WB\Desktop\vehicle-listing-backend\resources\views/admin/buyers/index.blade.php ENDPATH**/ ?>